<?php
/**
 * Display notices in admin.
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WC_CRM_Admin_Notices Class
 */
class WC_CRM_Admin_Notices extends WC_Admin_Notices {

	/**
	 * Array of notices - name => callback
	 * @var array
	 */
	private static $core_notices = array(
		'crm_install'  => 'crm_install_notice',
		'crm_update'   => 'crm_update_notice'
	);

	/**
	 * Constructor.
	 */
	public static function init() {
		add_action( 'wp_loaded', array( __CLASS__, 'hide_notices' ) );
		

		if ( current_user_can( 'manage_woocommerce' ) ) {
			add_action( 'admin_print_styles', array( __CLASS__, 'add_notices' ) );
		}
	}

	/**
	 * Remove all notices
	 */
	public static function remove_all_notices() {
		delete_option( 'wc_crm_admin_notices' );
	}

	/**
	 * Show a notice
	 * @param  string $name
	 */
	public static function add_notice( $name ) {
		$notices = array_unique( array_merge( get_option( 'wc_crm_admin_notices', array() ), array( $name ) ) );
		update_option( 'wc_crm_admin_notices', $notices );
	}

	/**
	 * Remove a notice from being displayed
	 * @param  string $name
	 */
	public static function remove_notice( $name ) {
		$notices = array_diff( get_option( 'wc_crm_admin_notices', array() ), array( $name ) );
		update_option( 'wc_crm_admin_notices', $notices );
	}

	/**
	 * See if a notice is being shown
	 * @param  string  $name
	 * @return boolean
	 */
	public static function has_notice( $name ) {
		return in_array( $name, get_option( 'wc_crm_admin_notices', array() ) );
	}


	/**
	 * Hide a notice if the GET variable is set.
	 */
	public static function hide_notices() {
		if ( isset( $_GET['wc-hide-notice'] ) && isset( $_GET['_wc_notice_nonce'] ) ) {
			if ( ! wp_verify_nonce( $_GET['_wc_notice_nonce'], 'woocommerce_hide_notices_nonce' ) ) {
				wp_die( __( 'Action failed. Please refresh the page and retry.', 'woocommerce' ) );
			}

			if ( ! current_user_can( 'manage_woocommerce' ) ) {
				wp_die( __( 'Cheatin&#8217; huh?', 'woocommerce' ) );
			}

			$hide_notice = sanitize_text_field( $_GET['wc-hide-notice'] );
			self::remove_notice( $hide_notice );
			do_action( 'woocommerce_hide_' . $hide_notice . '_notice' );
		}
	}

	/**
	 * Add notices + styles if needed.
	 */
	public static function add_notices() {
		$notices = get_option( 'wc_crm_admin_notices', array() );
		if ( $notices ) {
			wp_enqueue_style( 'woocommerce-activation', plugins_url(  '/assets/css/activation.css', WC_PLUGIN_FILE ) );
			foreach ( $notices as $notice ) {
				if ( ! empty( self::$core_notices[ $notice ] ) && apply_filters( 'woocommerce_show_admin_notice', true, $notice ) ) {
					add_action( 'admin_notices', array( __CLASS__, self::$core_notices[ $notice ] ) );
				}
			}
		}
	}

	/**
	 * If we need to update, include a message with the update button
	 */
	public static function crm_update_notice() {
		include( 'views/html-notice-update.php' );
	}

	/**
	 * If we have just installed, show a message with the install pages button
	 */
	public static function crm_install_notice() {
		include( 'views/html-notice-install.php' );
	}
}

WC_CRM_Admin_Notices::init();