<?php get_header(); ?>

<div class="bg-lightest pd-v-lg">

	<div class="container space-2">

		<div class="container text-center space-2">

			<h2>Basket</h2>

		</div>

		<?php
		// var_dump($_SESSION["basket"]);
		// unset($_SESSION["basket"]);
		?>

		<?php if ( !basket_wine_box_check() ) { ?>

			<div class="alert alert-warning space-2" id="alert-bottles">Please make sure you order bottles in multiples of 12 to fill a case.</div>
		<?php } ?>

			<?php if ( isset($_SESSION["basket"]) ) {
				$items = $_SESSION["basket"]['items'];
			}
			?>
			<?php if ( isset($items) && !empty($items) ) { ?>

			<?php require 'include/template/voucher.php'; ?>

			<table class="table table-basket" cellspacing="0" cellpadding="0">

				<thead>

					<tr>

						<th class="table-basketthumb">Item</th>

						<th class="table-basketprice mobile-hide">Item Price</th>

						<th class="table-basketquantity">Quantity</th>

						<th class="table-baskettotal text-right">Item Total</th>
					</tr>

				</thead>

				<tbody>
					<?php foreach ($items as $item) { ?>
					<?php 
					$product = $item["product"];
					$variation = $item["variation"];
					$quantity = $item["quantity"];
					if ( isset( $item["gift"] ) ) {
						$gift = $item["gift"];
					} else {
						$gift = 0;
					} ?>
					<?php if ( $product = get_post( $product ) ) { ?>
					<?php
					$item_price = get_item_price( $product, $variation );
					$total = $item_price * $quantity;
					$id = $product->ID;
					?>

					<tr class="item">
						
						<td class="td-item">

							<a href="<?php echo get_permalink($id); ?>"><strong><?php echo $product->post_title; ?></strong><br>
							<?php echo get_variation_details( $product, $variation, $gift ); ?></a>
						
						</td>
						
						<td class="mobile-hide">

                            &pound;<?php echo number_format((float)$item_price, 2, '.', ''); ?> <span class="text-meta text-faded">(excl VAT)</span>
							
						</td>
						
						<td class="td-quantity">

							<form action="<?php the_permalink(); ?>" method="post" class="standard_form" id="basket_update_form">
								
								<input type="hidden" value="<?php echo $product->ID; ?>" name="product" />
								<?php if ( !is_null( $variation ) ) { ?>
								<?php foreach ($variation as $var) { ?>
							
								<input type="hidden" value="<?php echo $var; ?>" name="variation[]" />
								<?php } ?>
								<?php } ?>

								<input type="hidden" name="gift" value="<?php echo $gift; ?>" />

								<div class="form-row">

									<div class="qty-wrap">

										<input type="number" name="quantity" class="input qty" value="<?php echo $quantity; ?>" min="1" />

										<input type='button' value='-' class='qtyminus' field='quantity' />

										<input type='button' value='+' class='qtyplus' field='quantity' />

									</div>

								</div>

								<input type="submit" class="update btn btn-update" value="update" /><input type="submit" class="remove btn btn-update" value="remove" /><div class="text-meta update_message"></div>

							</form>

						</td>

						<td class="text-right">
							
							&pound;<span class="item-total"><?php echo number_format( (float)$total, 2 ); ?></span><span class="text-meta text-faded">(excl VAT)</span>
						
						</td>

					</tr>
					<?php } //if post found ?>

					<?php } ?>

				</tbody>

			</table>

			<div class="container basket-discount">
				<div class="col-6 col-12-xs">

					<form action="<?php the_permalink(); ?>" method="post">
						<div class="form-row form-inline">
						<?php if ( empty( $_SESSION["basket"]['voucher']['id'] ) ) { ?>
							<input type="text" name="voucher_code" value="" placeholder="Enter your discount code" class="input" />
							<button type="submit" class="btn btn-grey"><i class="icon-plus"></i></button>
						<?php } else {
							$ID = $_SESSION["basket"]['voucher']['id'];
							$entity = get_post_meta($ID, 'entity', true);
							$unit = get_post_meta($ID, 'unit', true);
							$apply_to = get_post_meta($ID, 'apply_to', true);
							$code = get_post_meta($ID, 'voucher_code', true);
							if ( $entity == 'percentage' ) {
								$voucher_desc = $unit . '% off ' . $apply_to;
							} else {
								$voucher_desc = '&pound;' . $unit . ' off ' . $apply_to;
							}
							?>
							<label>Voucher Code <strong><?php echo $code; ?></strong> applied (<?php echo $voucher_desc; ?>)</label>
							<input type="hidden" name="remove-voucher" value="1" />
							<button type="submit" class="btn btn-grey"><i class="icon-close"></i></button>
						<?php } ?>
						</div>
					</form>
				</div>
				<div class="col-6 col-12-xs text-right">
					<?php if ( !empty( $_SESSION["basket"]['voucher']['id'] ) ) { $discount = voucher_saving(basket_sub_cost()); ?><p>Discounts: -&pound;<span id="basket-discount"><?php echo number_format( (float)$discount, 2 ); ?></span></p><?php } ?>
				</div>
			</div>

			<div class="container">

				<div class="col-12 text-right text-left-xs">

					<div class="space-1">Sub total: &pound;<span id="basket-sub-cost"><?php echo basket_cost(); ?></span> <span class="text-meta text-faded">(inc VAT)</span></div>

					<div class="space-1">Delivery: <?php if ( delivery_total_cost() ) { ?>&pound;<?php echo '<span id="basket-delivery-cost">' . delivery_total_cost() . '</span>'; } else { ?>Free<?php } ?></div>

					<div class="space-1 text-lg">

						<div class="basket-total">

							<strong>Total: <span class="text-highlight text-price">&pound;<span id="basket-total-cost"><?php echo basket_total_cost(); ?></span></span> <span class="text-meta text-faded">(inc VAT)</span></strong>

							<a href="<?php echo site_url('checkout/?step=1&amp;ref=basket'); ?>" class="btn btn-primary btn-large<?php if ( !basket_wine_box_check() ) { ?> btn-disabled<?php } ?>" id="btn-checkout">Checkout</a>

						</div>

					</div>

					<a href="<?php echo site_url('/'); ?>">Continue Shopping &#xffeb;</a>
				
				</div>

			</div>
			<?php } else { ?>

			<div class="alert alert-warning">Your basket is currently empty <a href="<?php echo site_url('/'); ?>" title="Continue shopping">Contine Shopping</a></div>
			<?php } ?>

	</div>

	<div class="container">

		<div class="alert alert-warning">
			Our online ordering system is operated by our UK distributor, Special Cases Limited. Please view their <a href="<?php echo site_url('terms-conditions'); ?>">terms and conditions of sale</a>.
		</div>

	</div>

</div>
<?php $minOrder = get_field('minimum_order', 'options'); ?>

<div class="modal" data-modal-id="minimum-order">

	<button data-modal-action="close" class="modal-close"><i class="icon-close"></i></button>
	<?php if ( $minOrder ) { ?>

	<div class="content">

		<?php echo $minOrder; ?>

	</div>
	<?php } ?>

</div>
<?php get_footer(); ?>