<?php
class WorldPay_Response {
    // define properties
    public $transaction_id = null;
    public $transaction_status = null;
    public $transaction_time = null;
    public $authorisation_amount = null;
    public $authorisation_currency = null;
    public $authorisation_amount_string = null;
    public $raw_auth_message = null;
    public $raw_auth_code = null;
    public $callback_password = null;
    public $card_type = null;
    public $authentication = null;
    public $ip_address = null;
    public $character_encoding = null;
    public $future_payment_id = null;
    public $future_payment_status_change = null;

    //custom properties not included by worldpay
    public $mc_custom_property = null;

    // constructor
    public function __construct() {
        $this->transaction_id = $_POST['transId'];
        $this->transaction_status = $_POST['transStatus']; //should be either Y (successful) or C (cancelled)
        $this->transaction_time = $_POST['transTime'];
        $this->authorisation_amount = $_POST['authAmount'];
        $this->authorisation_currency = $_POST['authCurrency'];
        $this->authorisation_amount_string = $_POST['authAmountString'];
        $this->raw_auth_message = $_POST['rawAuthMessage'];
        $this->raw_auth_code = $_POST['rawAuthCode'];
        $this->callback_password = $_POST['callbackPW'];
        $this->card_type = $_POST['cardType'];
        $this->country_match = $_POST['countryMatch']; //Y - Match, N - Mismatch, B - Not Available, I - Country not supplied, S - Issue Country not available
        $this->waf_merchant_message = $_POST['wafMerchMessage'];
        $this->authentication = $_POST['authentication'];
        $this->ip_address = $_POST['ipAddress'];
        $this->character_encoding = $_POST['charenc'];
        $this->future_payment_id = $_POST['futurePayId'];
        $this->future_payment_status_change = $_POST['futurePayStatusChange'];

        //custom properties
        $this->mc_custom_property = $_POST['MC_custom_property'];

    }
}
if ( isset($_POST['transId']) ) {

	$wp_response = new WorldPay_Response();

	if ( $wp_response->transaction_status == "Y" ) {

		$order = $_SESSION["basket"]['order']['order_id'];
		$user_id = $_SESSION["basket"]['order']['order_user'];
		$user_info = get_userdata($user_id);

		$line1 = get_field('billing_address_1', $order);
		$line2 = get_field('billing_address_2', $order);
		$town = get_field('billing_town', $order);
		$postcode = get_field('billing_postcode', $order);
		$first_name = get_field('first_name', $order);
		$surname = get_field('last_name', $order);
		$nicename = $first_name . ' ' . $surname;

		//Update order status
		update_post_meta( $order, 'order_status', '3' );

		$items = get_field('items',$order);
		$subtotal = get_field('items_subtotal',$order);
		$delivery = get_field('delivery_cost',$order);
		$order_voucher = get_post_meta($order, 'order_voucher', true);
		$total = $subtotal + $delivery;

		$email = $user_info->user_email;

		$subj = 'Thank you for your order #' . $order;

		// Send email to customer
		ob_start();
		include( get_template_directory() . '/include/template/email/header.php' ); ?>
		<p>Hello <?php echo $nicename; ?>,</p>
		<p>Thank you for your order with Time For Wine.</p>
		<p>Your unique order reference number is: <strong><?php echo $order; ?></strong>. Please have this to hand if you need to contact us.</p>
		<p><?php echo get_field('complete_order_email', 'option'); ?></p><br /><br />
		<p><span style="font-weight:bold">Delivery Address:</span></p>
		<?php echo $nicename; ?><br />
		<?php if ( $line1 ) { ?>
		<?php echo $line1; ?><br />
		<?php } ?>
		<?php if ( $line2 ) { ?>
		<?php echo $line2; ?><br />
		<?php } ?>
		<?php if ( $town ) { ?>
		<?php echo $town; ?><br />
		<?php } ?>
		<?php if ( $postcode ) { ?>
		<?php echo $postcode; ?><br />
		<?php } ?>
		<?php if ( isset($tel) ) { ?>
		<?php echo $tel; ?>
		<?php } ?>
		<br /><br />
		<p><span style="font-weight:bold">Order Review:</span></p>
		<table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
			<tbody>
				<?php foreach ($items as $item) {
					$product = $item["product"];
					$variation = $item["variation"];
					$quantity = $item["quantity"];
					$gift = $item["gift"];
					$item_price = get_item_price( $product, $variation );
					$item_total = $item_price * $quantity;
					if ( $product = get_post( $product ) ) {  ?>

						<tr class="item">
							<td><a href="<?php echo get_permalink( $product->ID ); ?>" target="_blank">x<?php echo $quantity; ?> <?php echo $product->post_title; ?></a><br /><?php echo get_variation_details( $product, $variation, $gift ); ?></td>
							<td style="text-align: right;">&pound;<?php echo number_format((float)$item_total, 2, '.', ''); ?></td>
						</tr>
							<?php } //if post found ?>
						<?php } ?>

					</tbody>
				</table>
				<table border="0" cellpadding="0" cellspacing="0" style="width:100%;" align="right">
					<tbody>
						<?php if ( !empty($order_voucher) ) { ?>
						<tr><td style="padding: 10px 0; border-top: 1px solid #EEE; text-align: right;">Voucher used: <strong><?php echo get_the_title($order_voucher); ?></strong></td></tr>
						<?php } ?>
						<tr><td style="padding: 10px 0; text-align: right;">Delivery: £<?php echo $delivery; ?></td></tr>
						<tr><td style="padding: 10px 0; text-align: right;">Sub-total: £<?php echo $subtotal; ?></td></tr>
						<tr><td style="padding-top: 10px; border-top: 1px solid #EEE; text-align: right;font-weight: bold;">Total: £<?php echo number_format( (float)$total, 2, '.', '' ); ?></td></tr>
					</tbody>
				</table><br /><br />
				<?php include( get_template_directory() . '/include/template/email/footer.php' );
				$message = ob_get_contents();
				ob_end_clean();
				wp_mail($email, 'Time For Wine: Order Confirmation ' . $order, $message);
				//End email message

				// Send email to admin
				ob_start();
				include( get_template_directory() . '/include/template/email/header.php' ); ?>
				<p>Please dispatch to the following address:</p>
				<?php echo $nicename; ?><br />
				<?php if ( $line1 ) { ?>
				<?php echo $line1; ?><br />
				<?php } ?>
				<?php if ( $line2 ) { ?>
				<?php echo $line2; ?><br />
				<?php } ?>
				<?php if ( $town ) { ?>
				<?php echo $town; ?><br />
				<?php } ?>
				<?php if ( $postcode ) { ?>
				<?php echo $postcode; ?><br />
				<?php } ?>
				<?php if ( isset($tel) ) { ?>
				<?php echo $tel; ?>
				<?php } ?>
				<br /><br />
				<p><span style="font-weight:bold">Order Review:</span></p>
				<table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
					<tbody>
				<?php foreach ($items as $item) {
					$product = $item["product"];
					$variation = $item["variation"];
					$quantity = $item["quantity"];
					$gift = $item["gift"];
					$item_price = get_item_price( $product, $variation );
					$item_total = $item_price * $quantity;
					if ( $product = get_post( $product ) ) {  ?>

						<tr class="item">
							<td><a href="<?php echo get_permalink( $product->ID ); ?>" target="_blank">x<?php echo $quantity; ?> <?php echo $product->post_title; ?></a><br /><?php echo get_variation_details( $product, $variation, $gift ); ?></td>
							<td style="text-align: right;">&pound;<?php echo number_format((float)$item_total, 2, '.', ''); ?></td>
						</tr>
						<?php } //if post found ?>
						<?php } ?>

							</tbody>
						</table>
						<table border="0" cellpadding="0" cellspacing="0" style="width:100%;" align="right">
							<tbody>
								<?php if ( !empty($order_voucher) ) { ?>
								<tr><td style="padding: 10px 0; border-top: 1px solid #EEE; text-align: right;">Voucher used: <strong><?php echo get_the_title($order_voucher); ?></strong></td></tr>
								<?php } ?>
								<tr><td style="padding: 10px 0; text-align: right;">Delivery: £<?php echo $delivery; ?></td></tr>
								<tr><td style="padding: 10px 0; text-align: right;">Sub-total: £<?php echo $subtotal; ?></td></tr>
								<tr><td style="padding-top: 10px; border-top: 1px solid #EEE; text-align: right;font-weight: bold;">Total: £<?php echo number_format( (float)$total, 2, '.', '' ); ?></td></tr>
							</tbody>
						</table><br /><br />

						<?php include( get_template_directory() . '/include/template/email/footer.php' );
						$message = ob_get_contents();
						ob_end_clean();
						wp_mail('tom@838888.co.uk', 'New Time For Wine Order #' . $order, $message);
						//End email message

						//terminate session
						unset($_SESSION['basket']);

					} else {
						echo "Validation error";
					}
				} else {
					echo 'Error';
				}
// } ?>