<?php
if (!is_user_logged_in()) { wp_redirect('login?done=checkout'); exit; }
if ( !basket_wine_box_check() ) { wp_redirect('basket'); exit; }
$current_user = wp_get_current_user();
$user_id = $current_user->ID;
if ( !($current_user instanceof WP_User) ) { return; }
if ( empty($_SESSION["basket"]['items']) ) { wp_redirect( site_url() ); exit(); }

// unset($_SESSION['basket']);

//Step 1 proccessing
if ( isset($_GET["step"]) && $_GET["step"] == '1' && 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'checkout' && wp_verify_nonce($_POST['checkout_nonce_field'],'verify_true_checkout') && $_POST['formName'] == 'checkout' ) {
	//First we need to create the order in the DB & generate an order no
	require 'include/template/checkout/delivery-process.php';
}

//Step 2 proccessing
if ( isset($_GET["step"]) && $_GET["step"] == '2' && 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'checkout' && wp_verify_nonce($_POST['checkout_nonce_field'],'verify_true_checkout') && $_POST['formName'] == 'checkout' ) {
    wp_redirect( site_url('checkout/?step=3') ); exit;
}

//Step 3 proccessing
if ( isset($_GET["step"]) && $_GET["step"] == '3' && 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'checkout' && wp_verify_nonce($_POST['checkout_nonce_field'],'verify_true_checkout') && $_POST['formName'] == 'checkout' ) {
	//if user is a guest, log them out
	$guest = get_user_meta( $user_id, 'guest', 1);
	if ( isset($guest) ) {
		wp_logout();
	}
	if ( !isset( $_SESSION["basket"]['order'] ) ) {
		wp_redirect( home_url() ); exit;
	}
}

?>

<?php get_header(); ?>

<div class="bg-lightest pd-v-lg">

	<div class="container container-narrow">

		<div class="text-center space-2">

			<h2>Checkout</h2>

		</div>

		<?php if ( isset($_GET["step"]) && $_GET["step"] == '1' ) {
			
			require 'include/template/checkout/create-order.php';
			require 'include/template/checkout/delivery-address-form.php';

			} elseif ( isset($_GET["step"]) && $_GET["step"] == '2' ) {

			require 'include/template/checkout/payment-form.php';

			} elseif ( isset($_GET["step"]) && $_GET["step"] == '3' ) {

			require 'include/template/checkout/complete.php';
		} ?>

	</div>

</div>

<?php get_footer(); ?>