<?php 
function basket_session() {
  if( !session_id() ) {
    session_start();
  }
}
add_action('init', 'basket_session', 1);

function basket_item_count() {
  if ( isset($_SESSION['basket']['items']) ) {
    $items = $_SESSION['basket']['items'];
    $i = 0;
    foreach ( $items as $item ) {
      $i++;
    }
    return $i;
  } else {
    return "0";
  }
}

function basket_wine_check() {
  if ( isset($_SESSION['basket']['items']) ) {
    $items = $_SESSION['basket']['items'];
    foreach ( $items as $item ) {
      $type = get_field( 'type', $item['product'] );
      if ( $type == 'wine' ) {
        return true;
        break;
      }
    }
  }
  return false;
}

function basket_subscription_gift_check() {
  if ( isset($_SESSION['basket']['items']) ) {
    $items = $_SESSION['basket']['items'];
    foreach ( $items as $item ) {
      if ( get_post_type( $item['product'] ) == 'subscription' && $item['gift'] ) {
        return true;
        break;
      }
    }
  }
  return false;
}

function basket_wine_count() {
  if ( isset($_SESSION['basket']['items']) ) {
    $items = $_SESSION['basket']['items'];
    $i = 0;
    foreach ( $items as $item ) {
      /*$type = get_field( 'type', $item['product'] );
      if ( $type == 'wine' ) {
        $i = $i + $item['quantity'];
      }*/
	    $i = $i + $item['quantity'];
    }
    return $i;
  } else {
    return "0";
  }
}

function basket_wine_box_check() {
  $bottles = basket_wine_count();
  error_log('basket_wine_count = '.$bottles);
  if ( basket_wine_check() && !empty( $bottles ) && $bottles % 12 == 0 || empty($bottles) ) {
    return true;
  } else {
    return false;
  }
}

function delivery_total_cost($order = null) {
  if ( $order ) {
    $voucher = get_post_meta($order, 'order_voucher', true);
  } elseif ( isset($_SESSION["basket"]['voucher']['id']) ) {
    $voucher = $_SESSION["basket"]['voucher']['id'];
  }
  if ( isset( $voucher ) ) {
    $postage = get_post_meta($voucher, 'apply_to', true);
    if ( $postage == 'postage' ) {
      $entity = get_post_meta($voucher, 'entity', true);
      $unit = get_post_meta($voucher, 'unit', true);
    }
  }
  if ( $order ) {
    $cost = basket_cost($order);
  } else {
    $cost = basket_cost();
  }
  $ranges = get_field('postage', 'options');
  if ( $ranges ) {
    foreach ($ranges as $range) {
      $rangeUpto = $range['order_value_up_to'];
      $rangeCost = $range['cost'];
      if ( $cost < $rangeUpto ) {
        if ( isset($unit) && isset($entity) && $entity == 'percentage' ) {
          $discount = ( $rangeCost / 100 ) * $unit;
          return max(0, number_format($rangeCost - $discount, 2));
        } elseif ( isset($unit) && isset($entity) ) {
          return max(0, number_format($rangeCost - $unit, 2));
        }
        return $rangeCost;
      }
    }
  }
  return 0;
}

function item_cost($item) {
  $product = $item["product"];
  $variation = $item["variation"];
  $quantity = $item["quantity"];
  $price = get_item_price( $product, $variation );
  $total = $price * $quantity;
  return $total;
}

function basket_sub_cost($order = null) {
  if ( $order ) {
    $items = get_field('items', $order);
  } else {
    $items = $_SESSION['basket']['items'];
  }
  if ( $items ) {
    $count = array();
    foreach ( $items as $item ) {
      $count[] = item_cost($item);
    }
    $total = array_sum($count);
    return number_format( (float)$total, 2, '.', '' );
  } else {
    return "0";
  }
}

function inc_VAT($exVAT) {
	$vat_rate = get_field('vat_rate','option');
	if(!$vat_rate) {
		$vat_rate = 20;
	}
	return ($exVAT)*(1 + ($vat_rate/100));
}

function basket_cost($order = null) {
  if ( $order ) {
    $items = get_field('items', $order);
  } elseif( isset( $_SESSION['basket']['items'] ) ) {
    $items = $_SESSION['basket']['items'];
  }
  if ( isset($items) ) {
    $count = array();
    foreach ( $items as $item ) {
      $count[] = item_cost($item);
    }
    $total = array_sum($count);
    $voucher = total_voucher($total);
    if ( !empty($voucher) ) {
      $total = $voucher;
    }

    $total = inc_VAT($total);
    return number_format( (float)$total, 2, '.', '' );
  } else {
    return "0";
  }
}

function basket_total_cost($order = null) {
  $total = basket_cost($order) + delivery_total_cost($order);
  //error_log('basket_total_cost = '.$total);
  return number_format((float)$total, 2, '.', '');
}

function get_item_price( $product, $variation = null ) {
  $price = get_field('price', $product);
  $variations = get_field('variations', $product);
  if ( $variations && $variation ) {
    $i = 0;
    foreach ($variations as $option) {
      $varPrice = $option['options'][$variation[$i]]['price'];
      if ( $varPrice ) {
        $price = $price + $varPrice;
      }
      $i++;
    }
  }
  return $price;
}

function get_variation_details( $product, $variation, $gift = null ) {
  $variations = get_field('variations', $product);
  $html = '<span class="text-faded text-black text-meta">';
  if ( $variations && $variation ) {
    $i = 0;
    foreach ($variations as $option) {
      $html .= $option['title'] . ': ';
      $html .= $option['options'][$variation[$i]]['title']. ' ';
      $i++;
    }
  }
  if ( $gift ) {
    $html .= ' [Gift]';
  }
  $html .= '</span>';
  return $html;
}

function add_to_basket() {
  $variation = null;
  if ( isset($_REQUEST) ) {
    $product = $_REQUEST['product'];
    if ( isset($_REQUEST['variation']) && $_REQUEST['variation'] != 'undefined' ) {
      $variation = $_REQUEST['variation'];
    }
    $quantity = $_REQUEST['quantity'];
    $gift = $_REQUEST['gift'];

    //Validate quantity input
    if ( (is_int($quantity) || ctype_digit($quantity)) && (int)$quantity > 0 ) {
      $status = 'error';
      $msg = 'Invalid quantity';
    }

    //Check is post exists
    if( $product = get_post( $product ) ) {
      //product found set id
      $product = $product->ID;

      //Check session exists
      if(!isset($_SESSION['basket']['items'])){

        //if not create session array
        $_SESSION['basket']['items'] = array();
      }

      $product_exists = false;
      //Check is product exists in basket
      foreach ($_SESSION['basket']['items'] as $key => $object) {
        if (
          $object["product"] == $product &&
          $object["variation"] == $variation &&
          $object["gift"] == $gift ) {
	        	//if product found update quantity
           $_SESSION['basket']['items'][$key]['quantity'] = $_SESSION['basket']['items'][$key]['quantity'] + $quantity;
           $product_exists = true;
       }
     }

     if ( $product_exists ) {
		//Existing product updated
       $msg = '<div class="alert alert-success space-2"><strong>Success!</strong> Product quantity updated <a href="' . site_url('/basket/') . '">view your basket</a> or <a href="' . site_url('/checkout/?step=1') . '">checkout &#10142;</a></div>';
       $status = 'success';

     } else {

		//Add new product to basket
       array_push( $_SESSION['basket']['items'], array(
        "product" => $product,
        "variation" => $variation,
        "quantity" => $quantity,
        "gift" => $gift
      ) );
       $msg = '<div class="alert alert-success space-2"><strong>Success!</strong> New product added to your basket <a href="' . site_url('/basket/') . '">view your basket</a> or <a href="' . site_url('/checkout/?step=1') . '">checkout &#10142;</a></div>';
       $status = 'success';

     }

    //If order exists update
    if ( isset( $_SESSION["basket"]['order']['order_id'] ) ) {
      $order = $_SESSION["basket"]['order']['order_id'];
      //Set order items
      $items = $_SESSION['basket']['items'];
      $i = 0;
      foreach ($items as $item) {
        $product = $item['product'];
        $variation = $item['variation'];
        $quantity = $item['quantity'];
        $gift = $item['gift'];
        $item_price = get_item_price( $product, $variation );
        $total = $item_price * $quantity;
        update_post_meta( $order, 'items_'.$i.'_product', $product );
        update_post_meta( $order, '_items_'.$i.'_product', 'field_5b180a0df52bc' );
        update_post_meta( $order, 'items_'.$i.'_variation', $variation );
        update_post_meta( $order, '_items_'.$i.'_variation', 'field_5b193fef9873b' );
        update_post_meta( $order, 'items_'.$i.'_quantity', $quantity );
        update_post_meta( $order, '_items_'.$i.'_quantity', 'field_5b180a11f52bd' );
        update_post_meta( $order, 'items_'.$i.'_cost', number_format( (float)$total, 2 ) );
        update_post_meta( $order, '_items_'.$i.'_cost', 'field_5b193e6e3b25f' );
        update_post_meta( $order, 'items_'.$i.'_gift', $gift );
        update_post_meta( $order, '_items_'.$i.'_gift', 'field_5b4730de85c5e' );
        $i++; }
        update_post_meta( $order, 'items', $i+1 );
        update_post_meta( $order, '_items', 'field_5b180a05f52bb' );
        //Set order delivery info
        $delivery_cost = delivery_total_cost();
        update_post_meta( $order, 'delivery_cost', $delivery_cost );
        update_post_meta( $order, '_delivery_cost', 'field_5b180b166e8f2' );
        //set order total cost
        $items_subtotal = basket_cost();
        update_post_meta( $order, 'items_subtotal', $items_subtotal );
        update_post_meta( $order, '_items_subtotal', 'field_5b180ae20674a' );
        //set order total cost
        update_post_meta( $order, 'total', basket_cost() + delivery_total_cost() );
        update_post_meta( $order, '_total', 'field_5b194878d6f04' );
      }
     } else {
      $status = 'error';
      $msg = 'No product found';
    }
    $resp = array('status' => $status, 'msg' => $msg);
    header( "Content-Type: application/json" );
    echo json_encode($resp);
  }
  die();
}
add_action( 'wp_ajax_add_to_basket', 'add_to_basket' );
add_action( 'wp_ajax_nopriv_add_to_basket', 'add_to_basket' );

function update_basket() {

    $updated_quantity = null;
    $status = null;
    $delivery = null;
    $sub_total = null;
    $total = null;
    if ( isset($_REQUEST) ) {
      $product = $_REQUEST['product'];
      $variation = $_REQUEST['variation'];
      $quantity = $_REQUEST['quantity'];
      $gift = $_REQUEST['gift'];
      //Validate quantity input
      if ((is_int($quantity) || ctype_digit($quantity)) && (int)$quantity > 0 ) {
        $status = 'error';
        $msg = 'Invalid quantity';
      }

    //Check is post exists
    if( $product = get_post( $product ) ) {
      //product found set id
      $product = $product->ID;
      foreach ( $_SESSION['basket']['items'] as $key => $object ) {
          if (
            $object["product"] == $product &&
            $object["variation"] == $variation &&
            $object["gift"] == $gift ) {
          //if product found update quantity
          $item = $_SESSION['basket']['items'][$key]['product'];
          $_SESSION['basket']['items'][$key]['quantity'] = $quantity;
          $item_price = get_item_price( $product, $variation );
          $product_exists = true;
          $price = $item_price * $quantity;
          $price = number_format( (float)$price, 2, '.', '' );
          $sub_total = basket_cost();
          $delivery = delivery_total_cost();
          $total = basket_total_cost();
        }
      }
      if ( isset( $product_exists ) ) {
        //Existing product updated
        $msg = 'Quanity updated!';
        $status = 'success';
      } else {
        $msg = 'No product found in basket';
      }
      //If order exists update
      if ( isset( $_SESSION["basket"]['order']['order_id'] ) ) {
        $order = $_SESSION["basket"]['order']['order_id'];
        //Set order items
        $items = $_SESSION['basket']['items'];
        $i = 0;
        foreach ($items as $item) {
          $product = $item['product'];
          $variation = $item['variation'];
          $quantity = $item['quantity'];
          $gift = $item['gift'];
          $item_price = get_item_price( $product, $variation );
          $total = $item_price * $quantity;
          update_post_meta( $order, 'items_'.$i.'_product', $product );
          update_post_meta( $order, '_items_'.$i.'_product', 'field_5b180a0df52bc' );
          update_post_meta( $order, 'items_'.$i.'_variation', $variation );
          update_post_meta( $order, '_items_'.$i.'_variation', 'field_5b193fef9873b' );
          update_post_meta( $order, 'items_'.$i.'_quantity', $quantity );
          update_post_meta( $order, '_items_'.$i.'_quantity', 'field_5b180a11f52bd' );
          update_post_meta( $order, 'items_'.$i.'_cost', number_format( (float)$total, 2 ) );
          update_post_meta( $order, '_items_'.$i.'_cost', 'field_5b193e6e3b25f' );
          update_post_meta( $order, 'items_'.$i.'_gift', $gift );
          update_post_meta( $order, '_items_'.$i.'_gift', 'field_5b4730de85c5e' );
        $i++; }
        update_post_meta( $order, 'items', 1 );
        update_post_meta( $order, '_items', 'field_5b180a05f52bb' );
        //Set order delivery info
        $delivery_cost = delivery_total_cost();
        update_post_meta( $order, 'delivery_cost', $delivery_cost );
        update_post_meta( $order, '_delivery_cost', 'field_5b180b166e8f2' );
        //set order subtotal cost
        $items_subtotal = basket_cost();
        update_post_meta( $order, 'items_subtotal', $items_subtotal );
        update_post_meta( $order, '_items_subtotal', 'field_5b180ae20674a' );
        //set order total cost
        update_post_meta( $order, 'total', basket_cost() + delivery_total_cost() );
        update_post_meta( $order, '_total', 'field_5b194878d6f04' );
      }
    } else {
      $msg = 'No product found';
    }

    $bottleAlert = basket_wine_box_check();

    $resp = array('status' => $status, 'msg' => $msg, 'qty' => $quantity, 'price' => $price, 'sub' => $sub_total, 'delivery' => $delivery, 'total' => number_format( (float)($sub_total + $delivery), 2, '.', '' ), 'bottleAlert' => $bottleAlert);
    header( "Content-Type: application/json" );
    echo json_encode($resp);

  }
  die();
}
add_action( 'wp_ajax_update_basket', 'update_basket' );
add_action( 'wp_ajax_nopriv_update_basket', 'update_basket' );


function remove_basket() {

    if ( isset($_REQUEST) ) {
      $product = $_REQUEST['product'];
      $variation = $_REQUEST['variation'];
      $quantity = $_REQUEST['quantity'];
      $gift = $_REQUEST['gift'];

    //Validate quantity input
    if ((is_int($quantity) || ctype_digit($quantity)) && (int)$quantity > 0 ) {
      $status = 'error';
      $msg = 'Invalid quantity';
    }

    //Check is post exists
    if( $product = get_post( $product ) ) {
      //product found set id
      $product = $product->ID;

      foreach ($_SESSION['basket']['items'] as $key => $object) {
        if (
          $object["product"] == $product &&
          $object["variation"] == $variation &&
          $object["gift"] == $gift ) {
            unset($_SESSION['basket']['items'][$key]);
            $status = 'success';
            $sub_total = basket_cost();
            $delivery = delivery_total_cost();
            $total = basket_total_cost();
        }
      }

      //If order exists update
      if ( isset($_SESSION["basket"]['order'] ) ) {
        $order = $_SESSION["basket"]['order']['order_id'];
        //Set order items
        $items = $_SESSION['basket']['items'];
        $i = 0;
        foreach ($items as $item) {
          $product = $item['product'];
          $variation = $item['variation'];
          $quantity = $item['quantity'];
          $gift = $item['gift'];
          $item_price = get_item_price( $product, $variation );
          $total = $item_price * $quantity;
          update_post_meta( $order, 'items_'.$i.'_product', $product );
          update_post_meta( $order, '_items_'.$i.'_product', 'field_5b180a0df52bc' );
          update_post_meta( $order, 'items_'.$i.'_variation', $variation );
          update_post_meta( $order, '_items_'.$i.'_variation', 'field_5b193fef9873b' );
          update_post_meta( $order, 'items_'.$i.'_quantity', $quantity );
          update_post_meta( $order, '_items_'.$i.'_quantity', 'field_5b180a11f52bd' );
          update_post_meta( $order, 'items_'.$i.'_cost', number_format( (float)$total, 2 ) );
          update_post_meta( $order, '_items_'.$i.'_cost', 'field_5b193e6e3b25f' );
          update_post_meta( $order, 'items_'.$i.'_gift', $gift );
          update_post_meta( $order, '_items_'.$i.'_gift', 'field_5b4730de85c5e' );
        $i++; }
        update_post_meta( $order, 'items', $i+1 );
        update_post_meta( $order, '_items', 'field_5b180a05f52bb' );
        //Set order delivery info
        $delivery_cost = delivery_total_cost();
        update_post_meta( $order, 'delivery_cost', $delivery_cost );
        update_post_meta( $order, '_delivery_cost', 'field_5b180b166e8f2' );
        //set order subtotal cost
        $items_subtotal = basket_cost();
        update_post_meta( $order, 'items_subtotal', $items_subtotal );
        update_post_meta( $order, '_items_subtotal', 'field_5b180ae20674a' );
        //set order total cost
        update_post_meta( $order, 'total', basket_cost() + delivery_total_cost() );
        update_post_meta( $order, '_total', 'field_5b194878d6f04' );
      }

      if ( empty( $_SESSION['basket']['items'] ) ) {
        unset( $_SESSION['basket'] );
      }

    }

    $bottleAlert = basket_wine_box_check();

    $resp = array( 'status' => $status, 'sub' => $sub_total, 'delivery' => $delivery, 'total' => number_format( (float)($sub_total + $delivery), 2, '.', '' ), 'bottleAlert' => $bottleAlert);
    header( "Content-Type: application/json" );
    echo json_encode($resp);
  }
  die();
}
add_action( 'wp_ajax_remove_basket', 'remove_basket' );
add_action( 'wp_ajax_nopriv_remove_basket', 'remove_basket' );



function checkout_process() {

    if ( isset($_REQUEST) ) {
    $status = "error";

      $order = $_SESSION["basket"]['order']['order_id'];
      $user_id = $_SESSION["basket"]['order']['order_user'];

      $address1Err = $address2Err = $townErr = $postcodeErr = $titleErr = $firstnameErr = $lastnameErr = $telErr = $deliveryareaErr = "";

      $company = sanitize_text_field( $_REQUEST['payer_business_name'] );
      $line1 = sanitize_text_field( $_REQUEST['address1'] );
      $line2 = sanitize_text_field( $_REQUEST['address2'] );
      $line3 = sanitize_text_field( $_REQUEST['city'] );
      $town = sanitize_text_field( $_REQUEST['country'] );
      $postcode = sanitize_text_field( $_REQUEST['zip'] );
      $title = sanitize_text_field( $_REQUEST['title'] );
      $first_name = sanitize_text_field( $_REQUEST['first_name'] );
      $surname = sanitize_text_field( $_REQUEST['last_name'] );
      $tel = sanitize_text_field( $_REQUEST['custom'] );
      $nicename = $first_name . ' ' . $surname;

      if ( !empty( $company ) ) {
        if ( get_user_meta( $user_id, 'company', true ) ) {
          update_user_meta( $user_id, 'company', $company);
        } else {
          add_user_meta( $user_id, 'company', $company);
        }
        update_post_meta( $order, 'order_company', $company);
      } 

      if ( !empty( $line1 ) ) {
        if ( get_user_meta( $user_id, 'billing_address_1', true ) ) {
          update_user_meta( $user_id, 'billing_address_1', $line1);
          update_post_meta( $order, 'order_billing_address_1', $line1);
        } else {
          add_user_meta( $user_id, 'billing_address_1', $line1);
        }
        update_post_meta( $order, 'order_billing_address_1', $line1);
      } else {
        $address1Err = "Address line 1 required";
      }

      if ( !empty( $line2 ) ) {
        if ( get_user_meta( $user_id, 'billing_address_2', true ) ) {
          update_user_meta( $user_id, 'billing_address_2', $line2);
        } else {
          add_user_meta( $user_id, 'billing_address_2', $line2);
        }
        update_post_meta( $order, 'order_billing_address_2', $line2);
      } else {
        $address2Err = "Address line 2 required";
      }

      if ( !empty( $line3 ) ) {
        if ( get_user_meta( $user_id, 'billing_address_3', true ) ) {
          update_user_meta( $user_id, 'billing_address_3', $line3);
        } else {
          add_user_meta( $user_id, 'billing_address_3', $line3);
        }
        update_post_meta( $order, 'order_billing_address_3', $line3);
      }

      if ( !empty( $town ) ) {
        if ( get_user_meta( $user_id, 'billing_town', true ) ) {
          update_user_meta( $user_id, 'billing_town', $town);
        } else {
          add_user_meta( $user_id, 'billing_town', $town);
        }
        update_post_meta( $order, 'order_billing_town', $town);
      } else {
        $townErr = "Town required";
      }

      if ( !empty( $postcode ) ) {
        $postcode = strtoupper(str_replace(' ','',$postcode));
          if( preg_match("/^[A-Z]{1,2}[0-9]{2,3}[A-Z]{2}$/",$postcode) || preg_match("/^[A-Z]{1,2}[0-9]{1}[A-Z]{1}[0-9]{1}[A-Z]{2}$/",$postcode) || preg_match("/^GIR0[A-Z]{2}$/",$postcode)) {
          if (
            substr($postcode,0,2) == 'HE' ||
            substr($postcode,0,2) == 'KW' ||
            substr($postcode,0,2) == 'BT' ||
            substr($postcode,0,2) == 'IV' ||
            substr($postcode,0,2) == 'IM' ||
            substr($postcode,0,4) == 'TR21' ||
            substr($postcode,0,4) == 'TR22' ||
            substr($postcode,0,4) == 'TR23' ||
            substr($postcode,0,4) == 'TR24' ||
            substr($postcode,0,4) == 'TR25' ||
            substr($postcode,0,2) == 'GY' ||
            substr($postcode,0,2) == 'JE' ||
            substr($postcode,0,2) == 'ZE' ||
            substr($postcode,0,2) == 'PA' ||
            substr($postcode,0,4) == 'PO30' ||
            substr($postcode,0,4) == 'PO31' ||
            substr($postcode,0,4) == 'PO32' ||
            substr($postcode,0,4) == 'PO33' ||
            substr($postcode,0,4) == 'PO34' ||
            substr($postcode,0,4) == 'PO35' ||
            substr($postcode,0,4) == 'PO36' ||
            substr($postcode,0,4) == 'PO37' ||
            substr($postcode,0,4) == 'PO38' ||
            substr($postcode,0,4) == 'PO39' ||
            substr($postcode,0,4) == 'PO40' ||
            substr($postcode,0,4) == 'PO41'
          ) {
            $deliveryareaErr = "Unfortunatly we unable to deliver to the entered address, please call a member of our team on <strong>01472 371661</strong> to discuss delivery.";
          } else {
            if ( get_user_meta( $user_id, 'billing_postcode', true ) ) {
              update_user_meta( $user_id, 'billing_postcode', $postcode);
            } else {
              add_user_meta( $user_id, 'billing_postcode', $postcode);
            }
            update_post_meta( $order, 'order_billing_postcode', $postcode);
          }
        } else {
              $postcodeErr = "Invalid postcode";
          }
      } else {
        $postcodeErr = "Postcode required";
      }

      if ( !empty( $title ) ) {
        if ( get_user_meta( $user_id, 'title', true ) ) {
          update_user_meta( $order, 'title', $title);
        } else {
          add_user_meta( $user_id, 'title', $title);
        }
      } else {
        $titleErr = "Title required";
      }

      if ( !empty( $first_name ) ) {
        $user_firstname = get_user_meta( $user_id, 'last_name', true);
        if ( empty($user_firstname ) ) {
          update_user_meta( $user_id, 'first_name', $first_name);
        } else {
          add_user_meta( $user_id, 'first_name', $first_name);
        }
      } else {
        $firstnameErr = "First Name required";
      }

      if ( !empty( $surname ) ) {
        $user_lastname = get_user_meta( $user_id, 'last_name', true);
        if ( empty($user_lastname ) ) {
          update_user_meta( $user_id, 'last_name', $surname);
        } else {
          add_user_meta( $user_id, 'last_name', $surname);
        }
      } else {
        $lastnameErr = "Surname required";
      }

      if ( !empty( $tel ) ) {
        if( ctype_digit($tel) && (int)$tel > 0 ) {
          if ( get_user_meta( $user_id, 'telephone_number', true ) ) {
            update_user_meta( $user_id, 'telephone_number', $tel);
          } else {
            add_user_meta( $user_id, 'telephone_number', $tel);
          }
          update_post_meta( $order, 'order_telephone_number', $tel);
        } else {
          $telErr = "Invalid phone number"; 
        }
      } else {
        $telErr = "Telephone required";
      }

    update_post_meta( $order, 'order_name', $nicename );

    //Check all required fields have data
    if ( empty($address1Err) && empty($address2Err) && empty($townErr) && empty($postcodeErr) && empty($titleErr) && empty($firstnameErr) && empty($lastnameErr) && empty($telErr) && empty($deliveryareaErr) ) {
      $status = 'success';
    }

    $resp = array('status' => $status);
    header( "Content-Type: application/json" );
    echo json_encode($resp);

  }

  die();

}
add_action( 'wp_ajax_checkout_process', 'checkout_process' );
add_action( 'wp_ajax_nopriv_checkout_process', 'checkout_process' );