<?php
function new_modify_user_table( $column ) {
    $column['orders'] = 'Orders';
    $column['total'] = 'Spend';
    return $column;
}
add_filter( 'manage_users_columns', 'new_modify_user_table' );

function new_modify_user_table_row( $val, $column_name, $user_id ) {
    $user = get_userdata( $user_id );
    $args = array(
		'post_type' 		=> 		'orders',
		'posts_per_page' 	=> 		-1,
		'author'    		=> 		$user_id,
		'meta_query'    => array(
			'relation' => 'OR',
			array(
				'key'       => 'order_status',
				'value'     => 3,
				'compare'   => 'LIKE',
			),
			array(
				'key'       => 'order_status',
				'value'     => 4,
				'compare'   => 'LIKE',
			)
	    )
	);
	$orders = get_posts( $args );
	//If posts found
	$total_spend = array();
	$i = 0;
	if ( !empty($orders) ) {
		foreach( $orders as $order ) {
			$i++;
			$items_subtotal = get_post_meta($order->ID, 'items_subtotal', true);
			$delivery = get_post_meta($order->ID, 'delivery_cost', true);
			$total = $items_subtotal + $delivery;
			$total_spend[] = $total;
		}
	}
    switch ($column_name) {
        case 'orders' :
	        if ( $i == 0 ) {
	        	return '-';
	        } else {
	            return 'x'. $i;
	        }
            break;
        case 'total' :
        	if ( array_sum($total_spend) == 0 ) {
	        	return '-';
	        } else {
	            return '&pound;' . array_sum($total_spend);
	        }
            break;
        default:
    }
}
add_filter( 'manage_users_custom_column', 'new_modify_user_table_row', 10, 3 );
add_filter( 'manage_users_sortable_columns', 'add_users_sortable_columns' );

function add_users_sortable_columns( $columns ) {
  $columns['orders'] = 'orders';
  $columns['total'] = 'total';
  return $columns;
}

function extended_contact_info($user_contactmethods) {  
	$user_contactmethods = array(
		'company' => __('Company'),
		'billing_address_1' => __('Address One'),
		'billing_address_2' => __('Address Two'),
		'billing_address_3' => __('Address Three'),
		'billing_town' => __('Town / City'),
		'billing_postcode' => __('Postcode'),
		'telephone_number' => __('Phone Number')
	);  
	return $user_contactmethods;
}
add_filter('user_contactmethods', 'extended_contact_info');


//Add dashboard widget
add_action('wp_dashboard_setup', 'shop_dashboard_widget');
function shop_dashboard_widget() {
	global $wp_meta_boxes;
	if( current_user_can('editor') || current_user_can('administrator') ) {
		wp_add_dashboard_widget('shop_widget', 'Shop', 'shop_overview');
	}
}

function shop_overview() {
    $args = array(
		'post_type' 		=> 		'orders',
		'posts_per_page' 	=> 		-1,
		'meta_query'    => array(
			'relation' => 'OR',
			array(
				'key'       => 'order_status',
				'value'     => 3,
				'compare'   => 'LIKE',
			),
			array(
				'key'       => 'order_status',
				'value'     => 4,
				'compare'   => 'LIKE',
			)
	    )
	);
	$month_orders = get_posts( $args );
	$total_week_spend = array();
	$total_month_spend = array();
	$total_all_spend = array();
	$month_i = 0;
	$week_i = 0;
	$dispatch_i = 0;
	$all_i = 0;
	if ( !empty($month_orders) ) {
		foreach( $month_orders as $order ) {
			$all_i++;
			$items_subtotal = get_post_meta($order->ID, 'items_subtotal', true);
			$delivery = get_post_meta($order->ID, 'delivery_cost', true);
			$status = get_post_meta($order->ID, 'order_status', true);
			$total = $items_subtotal + $delivery;
			$total_all_spend[] = $total;
			if ( strtotime($order->post_date) > strtotime('-30 days') ) {
				$total_month_spend[] = $total;
				$month_i++;
			}
			if ( strtotime($order->post_date) > strtotime('-7 days') ) {
				$total_week_spend[] = $total;
				$week_i++;
			}
			if ( $status == 3 ) {
				$dispatch_i++;
			}
		}
	}
	$total_month_spend = array_sum($total_month_spend);
	$total_week_spend = array_sum($total_week_spend);
	$total_all_spend = array_sum($total_all_spend);
	echo '<table width="100%">';
	echo '<tr>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>' . $week_i . '</h2>orders in last week</a></td>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>&pound;' . number_format( $total_week_spend, 2, '.', '' ) . '</h2>sales in last week</a></td>';
	echo '</tr>';
	echo '<tr>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>' . $month_i . '</h2>orders in last 30 days</a></td>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>&pound;' . number_format( $total_month_spend, 2, '.', '' ) . '</h2>sales in last 30 days</a></td>';
	echo '</tr>';
	echo '<tr>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>' . $all_i . '</h2>orders all time</a></td>';
	echo '<td style="border-bottom: 1px solid #EEE; padding-bottom: 10px;"><a href="/wp-admin/edit.php?post_type=orders"><h2>&pound;' . number_format( $total_all_spend, 2, '.', '' ) . '</h2>sales all time</a></td>';
	echo '</tr>';
	if ( $dispatch_i > 0) {
		echo '<tr>';
		echo '<td style="padding-top: 10px;" colspan="2"><a href="/wp-admin/edit.php?post_type=orders">' . $dispatch_i . ' orders waiting to be dispatched</a></td>';
		echo '</tr>';
	}
	echo '</table>';
}

?>