<?php
$order = $_SESSION["basket"]['order']['order_id'];
$user_id = $_SESSION["basket"]['order']['order_user'];
$user_info = get_userdata($user_id);
$complete = get_post_meta($order, 'complete', true);
if ( $complete ) {
	//Clear complete meta
	delete_post_meta( $order, 'complete');

	$line1 = get_user_meta( $user_id, 'billing_address_1', true );
	$line2 = get_user_meta( $user_id, 'billing_address_2', true );
	$line3 = get_user_meta( $user_id, 'billing_address_3', true );
	$town = get_user_meta( $user_id, 'billing_town', true );
	$postcode = get_user_meta( $user_id, 'billing_postcode', true );
	$first_name = get_user_meta( $user_id, 'first_name', true );
	$surname = get_user_meta( $user_id, 'last_name', true );
	$title = get_user_meta( $user_id, 'title', true );
	$company = get_user_meta( $user_id, 'company', true );
	$tel = get_user_meta( $user_id, 'telephone_number', true );
	$nicename = ucwords($title) . ' ' . $first_name . ' ' . $surname;

	//Update order status
	update_post_meta( $order, 'order_status', '3' );

	$items = get_field('items', $order);
	$subtotal = get_field('items_subtotal',$order);
	$delivery = get_field('delivery_cost',$order);
	$order_voucher = get_post_meta($order, 'order_voucher', true);
	$total = $subtotal + $delivery;

	$email = $user_info->user_email;

	$subj = 'Thank you for your order #' . $order;

	// Send email to customer
	ob_start();
	include( get_template_directory() . '/include/template/email/header.php' ); ?>
	<p>Hello <?php echo $nicename; ?>,</p>
	<p>Thank you for your order with Dyson Wine.</p>
	<p>Your unique order reference number is: <strong><?php echo $order; ?></strong>. Please have this to hand if you need to contact us.</p>
	<p><?php echo get_field('complete_order_email', 'option'); ?></p><br /><br />
	<p><span style="font-weight:bold">Delivery Address:</span></p>
	<?php echo $nicename; ?><br />
	<?php if ( $company ) { ?>
		<?php echo $company; ?><br />
	<?php } ?>
	<?php if ( $line1 ) { ?>
		<?php echo $line1; ?><br />
	<?php } ?>
	<?php if ( $line2 ) { ?>
		<?php echo $line2; ?><br />
	<?php } ?>
	<?php if ( $line3 ) { ?>
		<?php echo $line3; ?><br />
	<?php } ?>
	<?php if ( $town ) { ?>
		<?php echo $town; ?><br />
	<?php } ?>
	<?php if ( $postcode ) { ?>
		<?php echo $postcode; ?><br />
	<?php } ?>
	<?php if ( isset($tel) ) { ?>
		<?php echo $tel; ?>
	<?php } ?>
	<br /><br />
	<p><span style="font-weight:bold">Order Review:</span></p>
	<table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
		<tbody>
			<?php foreach ($items as $item) {
				$product = $item["product"];
				if ( isset($item["variation"]) ) {
					$variation = $item["variation"];
				} else {
					$variation = null;
				}
				$quantity = $item["quantity"];
				$gift = $item["gift"];
				$item_price = get_item_price( $product, $variation );
				$item_total = $item_price * $quantity;
				if ( $product = get_post( $product ) ) {  ?>

					<tr class="item">
						<td><a href="<?php echo get_permalink( $product->ID ); ?>" target="_blank">x<?php echo $quantity; ?> <?php echo $product->post_title; ?></a><br /><?php echo get_variation_details( $product, $variation, $gift ); ?></td>
						<td style="text-align: right;">&pound;<?php echo number_format((float)$item_total, 2, '.', ''); ?></td>
					</tr>
				<?php } //if post found ?>
			<?php } ?>

		</tbody>
	</table>
	<table border="0" cellpadding="0" cellspacing="0" style="width:100%;" align="right">
		<tbody>
			<?php if ( !empty($order_voucher) ) { ?>
				<tr><td style="padding: 10px 0; border-top: 1px solid #EEE; text-align: right;">Voucher used: <strong><?php echo get_the_title($order_voucher); ?></strong></td></tr>
			<?php } ?>
			<tr><td style="padding: 10px 0; text-align: right;">Delivery: £<?php echo $delivery; ?></td></tr>
			<tr><td style="padding: 10px 0; text-align: right;">Sub-total: £<?php echo $subtotal; ?></td></tr>
			<tr><td style="padding-top: 10px; border-top: 1px solid #EEE; text-align: right;font-weight: bold;">Total: £<?php echo number_format( (float)$total, 2, '.', '' ); ?></td></tr>
		</tbody>
	</table><br /><br />
	<?php include( get_template_directory() . '/include/template/email/footer.php' );
	$message = ob_get_contents();
	ob_end_clean();
	wp_mail($email, 'Dyson Wine: Order Confirmation ' . $order, $message);
		//End email message

		// Send email to admin
	ob_start();
	include( get_template_directory() . '/include/template/email/header.php' ); ?>
	<p>Please dispatch to the following address:</p>
	<?php echo $nicename; ?><br />
	<?php if ( $company ) { ?>
		<?php echo $company; ?><br />
	<?php } ?>
	<?php if ( $line1 ) { ?>
		<?php echo $line1; ?><br />
	<?php } ?>
	<?php if ( $line2 ) { ?>
		<?php echo $line2; ?><br />
	<?php } ?>
	<?php if ( $line3 ) { ?>
		<?php echo $line3; ?><br />
	<?php } ?>
	<?php if ( $town ) { ?>
		<?php echo $town; ?><br />
	<?php } ?>
	<?php if ( $postcode ) { ?>
		<?php echo $postcode; ?><br />
	<?php } ?>
	<?php if ( isset($tel) ) { ?>
		<?php echo $tel; ?><br />
	<?php } ?>
    <?php if($email) {
      echo $email.'<br />';
    }
    ?>
	<br /><br />
	<p><span style="font-weight:bold">Order Review:</span></p>
	<table border="0" cellpadding="0" cellspacing="0" style="width:100%;">
		<tbody>
			<?php foreach ($items as $item) {
				$product = $item["product"];
				if ( isset($item["variation"]) ) {
					$variation = $item["variation"];
				} else {
					$variation = null;
				}
				$quantity = $item["quantity"];
				$gift = $item["gift"];
				$item_price = get_item_price( $product, $variation );
				$item_total = $item_price * $quantity;
				if ( $product = get_post( $product ) ) {  ?>

					<tr class="item">
						<td><a href="<?php echo get_permalink( $product->ID ); ?>" target="_blank">x<?php echo $quantity; ?> <?php echo $product->post_title; ?></a><br /><?php echo get_variation_details( $product, $variation, $gift ); ?></td>
						<td style="text-align: right;">&pound;<?php echo number_format((float)$item_total, 2, '.', ''); ?></td>
					</tr>
				<?php } //if post found ?>
			<?php } ?>

		</tbody>
	</table>
	<table border="0" cellpadding="0" cellspacing="0" style="width:100%;" align="right">
		<tbody>
			<?php if ( !empty($order_voucher) ) { ?>
				<tr><td style="padding: 10px 0; border-top: 1px solid #EEE; text-align: right;">Voucher used: <strong><?php echo get_the_title($order_voucher); ?></strong></td></tr>
			<?php } ?>
			<tr><td style="padding: 10px 0; text-align: right;">Delivery: £<?php echo $delivery; ?></td></tr>
			<tr><td style="padding: 10px 0; text-align: right;">Sub-total: £<?php echo $subtotal; ?></td></tr>
			<tr><td style="padding-top: 10px; border-top: 1px solid #EEE; text-align: right;font-weight: bold;">Total: £<?php echo number_format( (float)$total, 2, '.', '' ); ?></td></tr>
		</tbody>
	</table><br /><br />

	<?php include( get_template_directory() . '/include/template/email/footer.php' );
	$message = ob_get_contents();
	ob_end_clean();
	$headers[] = 'From: Dyson Wine Website <no-reply@dysonwine.com>';
	$headers[] = 'Bcc: edward@technicks.com';
	if($email) {
		$headers[] = 'Reply-To: ' . $email;
	}
	wp_mail('specialcases@outlook.com', 'New Dyson Wine Order #' . $order, $message, $headers);
	//End email message

	//terminate session
	unset($_SESSION['basket']); ?>

	<div class="container narrow">
		<div class="form-wrapper alt_form text-center">
			<img src="<?php echo template_url('img/success.png'); ?>" alt="Success" width="80" height="80" class="space-2" />
			<h1 class="text-heading text-huge space-2">Thank you <?php echo $first_name; ?></h1>
			<p>Your order is complete. Your order number is <strong><?php echo $order; ?></strong>.</p>
			<p class="space-2"><strong>You will receive a confirmation email shortly.</strong></p>
			<p><a href="<?php echo site_url('/wine'); ?>" class="btn btn-primary">Return to shop</a></p>
		</div>
	</div>
<?php } else { ?>

	<div class="alert alert-error">An error occurred</div>

<?php } ?>