			<?php
			if ( isset($wine) ) {
				$id = $wine->ID;
			} else {
				$id = get_the_ID();
			}
			$images = get_field('images', $id);
			$vintage = get_field('vintage', $id);
			if ( $images ) { 
				$url = $images[0]["sizes"]["small-3x4"];
				$imgTitle = $images[0]["title"];
			} else {
				$url = site_url('img/default.jpg');
				$imgTitle = 'Default';
			} ?>

			<a href="<?php echo get_permalink($id); ?>" title="<?php echo get_the_title($id); ?>" class="product text-center">

				<div class="product-featured<?php if ( has_term('wine', 'type', $id) || has_term('olive-oil', 'type', $id) ) { echo ' wine-featured'; } if ( isset($wine) ) { echo ' wine-featured-sm'; } ?>">

					<?php if ( $vintage ) { echo '<span class="wine-vintage">' . $vintage . '</span>'; } ?>


					<img src="<?php echo $url; ?>" alt="<?php echo get_the_title($id); ?>" class="img-responsive" />

				</div>
				<?php if ( !has_term('wine', 'type', $id) && !has_term('olive-oil', 'type', $id) ) { ?>

				<div class="product-title pd-v-sm pd-h-md">

					<?php if ( $type == 'wine' ) { echo '<h4>Dyson Wine</h4>'; } ?>

					<h1 class="text-heading text-huge"><?php echo get_the_title($id); ?></h1>

					<span class="text-meta text-highlight">View More <i class="icon-arrow-right"></i></span>

				</div>
				<?php } ?>

			</a>