<?php if ( !is_user_logged_in() ) {
  wp_redirect( wp_login_url( site_url('wp-admin') ) );
  exit;
}
$order = get_post( get_query_var('receipt') );

if ( $order ) {

  require_once( get_template_directory() . '/include/tcpdf/tcpdf.php');

  $filename = $order->ID . '_receipt';
  $user_id = $order->post_author;
  //Get all user details 
  $user_info = get_userdata($user_id);
  $title = get_user_meta( $user_id, 'title', true );
  $first_name = get_user_meta( $user_id, 'first_name', true );
  $last_name = get_user_meta( $user_id, 'last_name', true );
  $last_name = get_user_meta( $user_id, 'last_name', true );

  $company = get_user_meta( $user_id, 'company', true );
  $line1 = get_user_meta( $user_id, 'billing_address_1', true );
  $line2 = get_user_meta( $user_id, 'billing_address_2', true );
  $line3 = get_user_meta( $user_id, 'billing_address_3', true );
  $town = get_user_meta( $user_id, 'billing_town', true );
  $postcode = get_user_meta( $user_id, 'billing_postcode', true );
  $tel = get_user_meta( $user_id, 'telephone_number', true );
  $email = $user_info->user_email;

  // create new PDF document
  $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

  // set margins
  $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT, PDF_MARGIN_BOTTOM);
  $pdf->setPrintHeader(false);
  $pdf->setPrintFooter(false);

  // set image scale factor
  $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

  // Add a page
  $pdf->AddPage();

  // Set some content to print
  $html = '<table style="width:100%;"><tr>';
  $html .='<td style="width:60%;"><img src="' . site_url() . '/img/logo.png" width="134" height="127" alt="Dyson Wine Logo"></td>';
  $html .='<td style="width:10%;"></td><td style="width:40%;"><p style="line-height:22px;font-size:13px;"><strong>Domaine Des Rabelles</strong><br> Quartier Les Sauvachans 83690 Villecroze,<br> France<br/>Tel: +33 6 11 99 80 16</p></td>';
  $html .='</tr></table>';
  $html .= '<h1 style="font-size: 28px;line-height:28px;">Purchase Receipt</h1>';
  $html .='<p style="color:#555;line-height:20px;font-size:13px;">Invoice No. ' . $order->post_title . '<br>';
    
    if ( !empty($title) && !empty($first_name) && !empty($last_name) ) {
     $html .= ucfirst($title) . " " . $first_name . " " . $last_name . "<br />";
    }
    if ( !empty( $company ) ) {
      $html .=  $company. ', <br>';
    }

    if ( !empty( $line1 ) ) {
      $html .=  $line1. ', <br>';
    }

    if ( !empty( $line2 ) ) { 
      $html .=  $line2. ', <br>';
   }

   if ( !empty( $line3 ) ) {
      $html .=  $line3. ', <br>';
    }

    if ( !empty( $town ) ) {
      $html .=  $town. ', <br>';
    }

    if ( !empty( $postcode ) ) {
      $html .= $postcode. '<br><br>';
    }
    if ( !empty($tel) ) {
        $html .= "Tel: <strong>" . $tel . "</strong><br />";
      }
      if ( !empty($email) ) {
        $html .= "Email: <strong>" . $email . "</strong>";
      }

  $html .= '</p>';
  $items = get_field('items', $order->ID);
  $subtotal = get_field('items_subtotal',$order->ID);
  $delivery = get_field('delivery_cost',$order->ID);
  $order_voucher = get_post_meta($order->ID, 'order_voucher', true);
  $total = $subtotal + $delivery;
  if ( $items ) {
    $html .= '<table cellpadding="5" style="width:100%;line-height:18px;font-size:13px;">';
    $html .= '<tr><td style="color:#999;font-size:11px; width:55%">Item</td><td style="color:#999;font-size:11px; width:15%;">Price</td><td style="color:#999;font-size:11px;text-align:right; width:30%;">Total</td></tr>';
    foreach ( $items as $item ) {
      $product = $item["product"];
      $variation = $item["variation"];
      $quantity = $item["quantity"];
      $gift = $item["gift"];
      $item_price = get_item_price( $product, $variation );
      $item_total = $item_price * $quantity;
      $html .= '<tr>';
      $html .= '<td style="border-bottom: 1px solid #EEE; width:55%">';
      $html .= 'x' . $item['quantity'] . ' ' . get_the_title($product) . '<br>';
      $html .= '<span style="color:#555;line-height:20px;font-size:11px;">' . get_variation_details( $product, $variation, $gift ) . '</span>';
      $html .= '</td>';
      $html .= '<td style="border-bottom: 1px solid #EEE; width:15%">&pound;' . number_format((float)$item_price, 2, '.', '') . '</td>';
      $html .= ' <td style="border-bottom: 1px solid #EEE;  width:30%; text-align: right;font-weight: bold;">&pound;' . number_format((float)$item_total, 2, '.', '') . '</td>';
      $html .= '</tr>';
    }
    if ( !empty($order_voucher) ) {
      $html .= '<tr><td colspan="3" style="padding: 10px 0; border-top: 1px solid #EEE; text-align: right;">Voucher used: <strong>' . get_the_title($order_voucher) . '</strong></td></tr>';
    }
    $html .= '<tr><td colspan="3" style="padding-top: 5px; text-align: right;">Delivery: £' . $delivery . '</td></tr>';
    $html .= '<tr><td colspan="3" style="padding: 5px 0; text-align: right;">Sub-total  £' . $subtotal . '</td></tr>';
    $html .= '<tr><td colspan="3" style="padding-top: 10px; border-top: 1px solid #EEE; text-align: right;font-weight: bold;">Total  £' . number_format((float)$total, 2, '.', '') . '</td></tr>';
    $html .= "</table>";
}

  $html .='<p style="line-height:24px;font-size:12px;">www.dyson-wine.com | +33 6 11 99 80 16<br/>';
  $html .='Domaine Des Rabelles, France</p>';

  // Write html to PDF
  $pdf->writeHTML($html, true, false, true, false, '');

  // Output PDF
  $pdf->Output( ABSPATH . 'receipts/' . $filename . '.pdf', 'F');

  update_post_meta($order->ID, 'receipt_created', $order->ID );

    $string = '<script type="text/javascript">';
    $string .= 'window.location = "' . site_url('receipts/' . $filename . '.pdf') . '"';
    $string .= '</script>';
    echo $string;

}