<?php
$type = get_sub_field('type');
$background_colour = get_sub_field("background_colour");
$padding = get_sub_field('padding');
?>

<div class="bg-<?php echo $background_colour; ?><?php if ( $background_colour == 'dark' ) { echo ' text-contrast'; } ?> pd-v-<?php echo $padding; ?>">

	<div class="container">

		<div class="col-12 col-12-sm">
		<?php
		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
		$tax_query_args = array('relation' => 'AND');
		if ( $type ) {
			$selectedTypes = array(
			    'taxonomy' 	=>	'type',
			    'terms' 	=>	$type,
			    'field'   	=>	'term_id'
			);
			array_push( $tax_query_args, $selectedTypes );
		}
		$args = array(
			'post_type' 		=>		'product',
	        'paged' 			=>		$paged,
	        'posts_per_page' 	=> 		-1,
	        'orderby'			=>		'menu_order'
		);
		$args["tax_query"] = $tax_query_args;
		$products = new WP_Query( $args );
		?>
		<?php if ( $products->have_posts() ) { ?>

			<div class="container space-3"></div>

			<ul class="container grid-col-2">
			<?php while ( $products->have_posts() ) { $products->the_post(); ?>

				<li class="space-5">
				<?php include get_template_directory() . '/include/template/loop/product.php'; ?>


				</li>
			<?php } ?>

			</ul>
			<?php if ( $products->max_num_pages > 1 ) { ?>

			<div class="container text-center">

				<?php pagination( $products->max_num_pages, 3); ?>

			</div>
			<?php } ?>
			<?php } else { ?>

			<div class="container">

				<div class="alert alert-warning">No products found</div>

			</div>
			<?php } ?>

		</div>

	</div>

</div>