<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<li <?php wc_product_class(); ?>>
<?php
	$id = $loop->post->ID;

	$images = wp_get_attachment_image_src( get_post_thumbnail_id( $loop->post->ID ), 'small-3x4' );
	$vintage = get_field('vintage', $id);
	if ( $images ) { 
		$url = $images[0];
	} else {
		$url = site_url('img/default.jpg');
	} 
	$product_categories = [];

	if ($terms = get_the_terms( $loop->post->ID, 'product_cat' )) {
		foreach ($terms as $term) {
			$product_categories[] = $term->slug;
		}
	}

	?>

	<a href="<?php echo get_permalink($id); ?>" title="<?php echo get_the_title($id); ?>" class="product text-center">

		<div class="product-featured <?=(in_array('wine', $product_categories) || in_array('olive-oil', $product_categories)) ? 'wine-featured' : '';?>">
			<?php if ( $vintage ) { echo '<span class="wine-vintage">' . $vintage . '</span>'; } ?>
			<img src="<?php echo $url; ?>" alt="<?php echo get_the_title($id); ?>" class="img-responsive" />
		</div>
		<?php if (!in_array('wine', $product_categories) && !in_array('olive-oil', $product_categories)) { ?>

		<div class="product-title pd-v-sm pd-h-md">
			<?php if ( $type == 'wine' ) { echo '<h4>Dyson Wine</h4>'; } ?>
			<h1 class="text-heading text-huge"><?php echo get_the_title($id); ?></h1>
			<span class="text-meta text-highlight">View More <i class="icon-arrow-right"></i></span>
		</div>
		<?php } ?>

	</a>
</li>
