<?php
$building = get_field('building', 'options');
$street = get_field('street', 'options');
$town = get_field('town', 'options');
$country = get_field('country', 'options');
$postcode = get_field('postcode', 'options');
?>
<?php if ( !is_page('vineyard') && !is_page('basket') && !is_page('checkout') ) { ?>

<div class="bg-cover text-center  bg-white text-contrast pd-v-xxl" style="background-image: url('/wp-content/uploads/2018/09/vineyard.jpg');">
	
	<div class="container">
		
		<div class="col-6 col-12-sm">
				
		<h4 class="text-light text-spaced text-uppercase">  &nbsp;&nbsp; A Bio-Active Vineyard</h4>
				
			<h1 class="text-heading text-jumbo space-1">Our Vineyard</h1>
					
			<a href="<?php echo site_url('vineyard'); ?>" class="btn btn-outline-light btn-more" title="<?php echo site_url('vineyard'); ?>">Find out more</a>
				
		</div>
		
	</div>

</div>
<?php } ?>

<footer class="footer pd-v-lg text-center">

	<div class="container">

		<div class="space-2">

			<img src="<?php echo template_url('img/logo.svg'); ?>" width="90" height="74" alt="Logo" class="img-logo space-0" />

			<h1 class="h4 text-black">Dyson<span class="text-faded">Wine</span></h1>

		</div>

		<p class="text-bold">Our UK Distributer is Special Cases</p>

		<p class="space-3">

			<a href="tel:<?php echo str_replace(' ', '', get_field('telephone', 'options') ); ?>" title="Call Us"><?php the_field('telephone', 'options'); ?></a> &nbsp;/&nbsp; <a href="mailto:<?php echo str_replace(' ', '', get_field('email', 'options') ); ?>" title="Email"><?php the_field('email', 'options'); ?></a>

		</p>


		<p class="text-bold">You must be 18 or over to buy alcohol. Please enjoy our wine responsibly.</p>
		<p class="space-3">L'abus d'alcool est dangereux pour la santé, consommez avec moderation.</p>


		<ul class="list-nav">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'footer',
					'items_wrap' => '%3$s',
					'container' => false,
					'walker' => new Header_Nav_Walker_Nav_Menu()
				)
			);
			?>

		</ul>

	</div>

	<div class="container container-narrow pd-v-md">

		<hr>

	</div>

	<div class="container">

		<p class="text-meta">&copy; <?php echo date('Y'); ?> <?php the_field('name', 'options'); ?></p>

	</div>

</footer>
<?php wp_footer(); ?>

<script async src="https://www.googletagmanager.com/gtag/js?id=UA-125013953-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());
  gtag('config', 'UA-125013953-1');
</script>
</body>

</html>