<?php
function ajax_contact_action_callback() {
	$msg = '';
	$status = 'error';
	if ( empty($_POST['name']) || empty($_POST['email']) || empty($_POST['telephone']) || empty($_POST['message']) ) {
		$msg = 'All fields are required.';
	} elseif ( !isset( $_POST['nonce'] ) || !wp_verify_nonce( $_POST['nonce'], 'auth' ) ) {
		$msg = 'Sorry, your nonce did not verify.';
	} else {
		$name = filter_var($_POST['name'], FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_LOW);
		$email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
		$tel = filter_var($_POST['telephone'], FILTER_SANITIZE_NUMBER_FLOAT);
		$enquiry = filter_var($_POST['message'], FILTER_SANITIZE_STRING);
		$message = '<strong>Name:</strong> ' . $name . '<br>';
		$message .= '<strong>E-mail address:</strong> ' . $email . '<br>';
		$message .= '<strong>Telephone Number:</strong> ' . $tel . '<br><br>';
		$message .= '<strong>Enquiry:</strong> <br>' . $enquiry . '<br><br><br>';
		$message .= 'Senders IP address: ' . $_SERVER['REMOTE_ADDR'];
		$header = 'Reply-To: ' . $email;
		if ( wp_mail('tom@838888.co.uk', 'Website Enquiry', $message, $header) ) {
			$status = 'success';
			$msg = 'Thankyou, your enquiry has been sent. A member of our team will be in touch shortly.';
		} else {
			$msg = 'Some errors occurred.';
		}
	}
	$resp = array('status' => $status, 'msg' => $msg);
	header( "Content-Type: application/json" );
	echo json_encode($resp);
	die();
}
add_action( 'wp_ajax_contact', 'ajax_contact_action_callback' );
add_action( 'wp_ajax_nopriv_contact', 'ajax_contact_action_callback' );

function ajax_newsletter_action_callback() {
  $msg = '';
  $status = 'error';
    if ( empty($_POST['email']) ) {
    $msg = 'All fields are required.';
  } elseif ( !isset( $_POST['nonce'] ) || !wp_verify_nonce( $_POST['nonce'], 'auth' ) ) {
    $msg = 'Sorry, your nonce did not verify.';
  } else {
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $apiKey = '365374f4cca335d8891ce881952b6f72-us19';
    $listID = '6312096975';
    $memberID = md5(strtolower($email));
    $dataCenter = substr($apiKey,strpos($apiKey,'-')+1);
    $url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listID . '/members/' . $memberID;
    $json = json_encode([ 'email_address' => $email, 'status' => 'pending' ]);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    if ($httpCode == 200) {
      $status = 'success';
      $msg = 'Thank you, please check your email.';
    } else {
      switch ($httpCode) {
		case 214:
			$msg = 'You are already subscribed.';
			break;
		default:
			$msg = 'Some problem occurred, please try again.';
			break;
      }
    }
  }
  $resp = array( 'status' => $status, 'msg' => $msg );
  header( "Content-Type: application/json" );
  echo json_encode($resp);
  die();  
}
add_action( 'wp_ajax_newsletter', 'ajax_newsletter_action_callback' );
add_action( 'wp_ajax_nopriv_newsletter', 'ajax_newsletter_action_callback' );

function ajax_process_action_callback() {
	$msg = '';
	$status = 'error';
	if ( !isset($_POST['address1'])  || !isset($_POST['first_name']) || !isset($_POST['last_name']) ) {
		$msg = 'All fields are required.';
	} elseif ( !isset( $_POST['nonce'] ) || !wp_verify_nonce( $_POST['nonce'], 'auth' ) ) {
		$msg = 'Sorry, your nonce did not verify.';
	} else {
		$order = $_SESSION["basket"]['order']['order_id'];
		$user_id = $_SESSION["basket"]['order']['order_user'];

		$title = sanitize_text_field( $_POST['title'] );
		$first_name = sanitize_text_field( $_POST['first_name'] );
		$last_name = sanitize_text_field( $_POST['last_name'] );
		$company = sanitize_text_field( $_POST['company'] );
		$line1 = sanitize_text_field( $_POST['address1'] );
		$line2 = sanitize_text_field( $_POST['address2'] );
		$line3 = sanitize_text_field( $_POST['address3'] );
		$town = sanitize_text_field( $_POST['town'] );
		$country = sanitize_text_field( $_POST['country'] );
		$postcode = sanitize_text_field( $_POST['postcode'] );
		$tel = sanitize_text_field( $_POST['tel'] );

		update_user_meta( $user_id, 'title', $title);
		update_user_meta( $user_id, 'first_name', $first_name);
		update_user_meta( $user_id, 'last_name', $last_name);
		update_user_meta( $user_id, 'company', $company);
		update_user_meta( $user_id, 'billing_address_1', $line1);
		update_user_meta( $user_id, 'billing_address_2', $line2);
		update_user_meta( $user_id, 'billing_address_3', $line3);
		update_user_meta( $user_id, 'billing_town', $town);
		update_user_meta( $user_id, 'billing_country', $country);

		if ( !empty( $postcode ) ) {
			$postcode = strtoupper(str_replace(' ','',$postcode));
		    if( preg_match("/^[A-Z]{1,2}[0-9]{2,3}[A-Z]{2}$/",$postcode) || preg_match("/^[A-Z]{1,2}[0-9]{1}[A-Z]{1}[0-9]{1}[A-Z]{2}$/",$postcode) || preg_match("/^GIR0[A-Z]{2}$/",$postcode)) {
				if (
					substr( $postcode, 0, 2 ) == 'HE' ||
					substr( $postcode, 0, 2 ) == 'KW' ||
					substr( $postcode, 0, 2 ) == 'BT' ||
					substr( $postcode, 0, 2 ) == 'IV' ||
					substr( $postcode, 0, 2 ) == 'IM' ||
					substr( $postcode, 0, 4 ) == 'TR21' ||
					substr( $postcode, 0, 4 ) == 'TR22' ||
					substr( $postcode, 0, 4 ) == 'TR23' ||
					substr( $postcode, 0, 4 ) == 'TR24' ||
					substr( $postcode, 0, 4 ) == 'TR25' ||
					substr( $postcode, 0, 2 ) == 'GY' ||
					substr( $postcode, 0, 2 ) == 'JE' ||
					substr( $postcode, 0, 2 ) == 'ZE' ||
					substr( $postcode, 0, 2 ) == 'PA' ||
					substr( $postcode, 0, 4 ) == 'PO30' ||
					substr( $postcode, 0, 4 ) == 'PO31' ||
					substr( $postcode, 0, 4 ) == 'PO32' ||
					substr( $postcode, 0, 4 ) == 'PO33' ||
					substr( $postcode, 0, 4 ) == 'PO34' ||
					substr( $postcode, 0, 4 ) == 'PO35' ||
					substr( $postcode, 0, 4 ) == 'PO36' ||
					substr( $postcode, 0, 4 ) == 'PO37' ||
					substr( $postcode, 0, 4 ) == 'PO38' ||
					substr( $postcode, 0, 4 ) == 'PO39' ||
					substr( $postcode, 0, 4 ) == 'PO40' ||
					substr( $postcode, 0, 4 ) == 'PO41'
				) {
					$msg = "Unfortunatly we unable to deliver to the entered address, please call a member of our team on <strong>01472 371661</strong> to discuss delivery.";
				} else {
					update_user_meta( $user_id, 'billing_postcode', $postcode);
				}
			} else {
			    $msg = "Invalid postcode";
		    }
		} else {
			$msg = "Postcode required";
		}
		if ( !empty( $tel ) ) {
			if( ctype_digit($tel) && (int)$tel > 0 ) {
				update_user_meta( $user_id, 'telephone_number', $tel);
			} else {
				$msg = "Invalid phone number";	
			}
		} else {
			$msg = "Telephone required";
		}
		if ( empty($msg) ) {
			$status = 'success';
			$msg = 'Yes';
		}
	}
	$resp = array('status' => $status, 'msg' => $msg);
	header( "Content-Type: application/json" );
	echo json_encode($resp);
	die();
}
add_action( 'wp_ajax_process', 'ajax_process_action_callback' );
add_action( 'wp_ajax_nopriv_process', 'ajax_process_action_callback' );