<?php 

function remove__views( $views ) {
    unset($views['publish']);
    return $views;
}
add_action( 'views_edit-orders', 'remove__views' );


function wpse_76815_remove_publish_box() {
  remove_meta_box( 'submitdiv', 'orders', 'side' );
}
add_action( 'admin_menu', 'wpse_76815_remove_publish_box' );


function add_order_action_meta_box() {
  add_meta_box(
        'order_action_meta_box',
        'Order Actions',
        'order_action_meta_box',
        'orders',
        'side',
        'high');
}
add_action('add_meta_boxes', 'add_order_action_meta_box');

function order_action_meta_box() {
  global $post;  
  $filename = $post->ID . '_receipt';
  $order_status = get_post_meta($post->ID, 'order_status', true);
  echo '<input type="hidden" name="order_action_meta_box_nonce" value="'.wp_create_nonce(basename(__FILE__)).'" />';  

  $order_status = get_post_meta($post->ID, 'order_status', true);
  ?>
<p>
<label for="">Order status</label>
  <select name="order_status">
  <option value="" selected disabled>Please select</option>
    <option value="3"<?php if ( $order_status == 3 ) { echo ' selected'; } ?>>Complete</option>
    <option value="4"<?php if ( $order_status == 4 ) { echo ' selected'; } ?>>Dispatched</option>
    <option value="5"<?php if ( $order_status == 5 ) { echo ' selected'; } ?>>Cancelled</option>
  </select>
</p>

  <p>
    <input name="save" type="submit" class="button button-primary button-large" id="publish" value="Update Order" />
  </p>

  <a href="<?php echo site_url('wp-admin/receipt/' . $filename . '.pdf'); ?>" class="button button-secondary button-large" target="_blank">Create VAT Receipt</a>

  <?php 
}

function save_order_action_meta($post_id) {   
        
    
    if ( !empty( $_POST['order_status'] ) ) {

    // check autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return $post_id;

        
    // check permissions
    if ( 'orders' == $_POST['post_type'] ) {
        if (!current_user_can('edit_page', $post_id))
            return $post_id;
        } elseif (!current_user_can('edit_post', $post_id)) {
            return $post_id;
    }  

    // verify nonce
    if (!wp_verify_nonce($_POST['order_action_meta_box_nonce'], basename(__FILE__)))
        return $post_id;

      $headers = 'Content-type: text/html';

      $user_id = get_post_field( 'post_author', $post_id );
      $user_info = get_userdata($user_id);
      $order_name = get_user_meta( $user_id, 'first_name', true ) . ' ' . get_user_meta( $user_id, 'last_name', true ); 
      $order_email = $user_info->user_email;
      $status = get_post_meta($post_id, "order_status", true);

      //Send email to customer notifiying of dispatch
      $multiple_recipients = $order_email;

      if ( $_POST['order_status'] == 5 ) {

        // Send email to customer
        ob_start();
        include( get_template_directory() . '/include/template/email/header.php' ); ?>
        <p>Hello <?php echo $order_name; ?>,</p>
        <p>Your order <?php echo $post_id; ?> has been cancelled.</p>
        <p><?php echo get_field('cancel_order_email', 'option'); ?></p>
        <?php include( get_template_directory() . '/include/template/email/footer.php' );
        $message = ob_get_contents();
        ob_end_clean();
        wp_mail($order_email, 'Your order ' . $post_id . ' has been cancelled', $message);
        //End email message

      } elseif ( $_POST['order_status'] == 4 && $status < 4) {

        // Send email to customer
        ob_start();
        include( get_template_directory() . '/include/template/email/header.php' ); ?>
        <p>Hello <?php echo $order_name; ?>,</p>
        <p>Your order <?php echo $post_id; ?> has been completed and is being dispatched via our courier.</p>
        <p><?php echo get_field('dispatch_order_email', 'option'); ?></p>
        <?php include( get_template_directory() . '/include/template/email/footer.php' );
        $message = ob_get_contents();
        ob_end_clean();
        wp_mail($order_email, 'Your order ' . $post_id . ' is on its way', $message);
        //End email message

      }

      $new = $_POST["order_status"];
      if ($new && $new != $status) {
          update_post_meta($post_id, "order_status", $new);
      } elseif ('' == $new && $status) {
          delete_post_meta($post_id, "order_status", $old);
      }
    }
}
add_action('save_post', 'save_order_action_meta');

add_action('do_meta_boxes', 'my_customize_meta_boxes'); //using do_meta_boxes also allows plugin metaboxes to be modified
function my_customize_meta_boxes(){
  $post_types = get_post_types();
  remove_meta_box( 'authordiv', $post_types, 'normal' );
  add_meta_box('authordiv', __('Order User'), 'post_author_meta_box', $post_types, 'side', 'default');
}

function add_order_details_meta_box() {
  add_meta_box(
        'order_details_meta_box', // $id
        'Order Details', // $title
        'order_details_meta_box', // $callback
        'orders', // $page
        'normal', // $context
        'high'); // $priority
}
add_action('add_meta_boxes', 'add_order_details_meta_box');

function order_details_meta_box() {
  global $post;
  $order_ip = get_post_meta($post->ID, 'order_ip', true);  

  if ( get_post_meta($post->ID, 'order_user', true) ) {
    $user_id = get_post_meta($post->ID, 'order_user', true);
  } else {
    $user_id = get_post_field( 'post_author', $post->ID );
  }
  $user_info = get_userdata($user_id);
  $order_name = get_user_meta( $user_id, 'first_name', true ) . ' ' . get_user_meta( $user_id, 'last_name', true ); 
  $order_email = $user_info->user_email;
  $order_telephone_number = get_user_meta( $user_id, 'telephone_number', true ); 

  $order_company = get_user_meta( $user_id, 'company', true ); 
  $order_billing_address_1 = get_user_meta( $user_id, 'billing_address_1', true ); 
  $order_billing_address_2 =  get_user_meta( $user_id, 'billing_address_2', true ); 
  $order_billing_address_3 = get_user_meta( $user_id, 'billing_address_3', true ); 
  $order_billing_town =  get_user_meta( $user_id, 'billing_town', true ); 
  $order_billing_postcode =  get_user_meta( $user_id, 'billing_postcode', true ); 

  $order_status = get_post_meta($post->ID, 'order_status', true);
  if ( $order_status  == 0 || $order_status  == 1 || $order_status  == 2 ) {
      $status = '<span style="color:#999;font-weight:bold;">Uncomplete</span>';
    }
    if ( $order_status  == 3 ) {
      $status = '<span style="color:orange;font-weight:bold;">Complete</span>';
    }
    if ( $order_status  == 4 ) {
      $status = '<span style="color:green;font-weight:bold;">Dispatched</span>';
    }
    if ( $order_status  == 5 ) {
      $status = '<span style="color:red;font-weight:bold;">Cancelled</span>';
    }
  ?>
  <h1>Order <?php echo $post->ID; ?> details</h1>
  <strong><?php echo $status; ?> - <?php
  $date = new DateTime( $post->post_date );
  echo $date->format('jS F Y @ g:iA'); ?></strong>
  <p><h3><a href="/wp-admin/user-edit.php?user_id=<?php echo $user_id; ?>"><?php echo $order_name; ?></a> - (<a href="mailto:<?php echo $order_email; ?>"><?php echo $order_email; ?></a>)</h3></p>
  <p>
    <?php if ( !empty( $order_company ) ) { ?>
      <?php echo $order_company; ?><br/>
    <?php } ?>

    <?php if ( !empty( $order_billing_address_1 ) ) { ?>
      <?php echo $order_billing_address_1; ?><br/>
    <?php } ?>

    <?php if ( !empty( $order_billing_address_2 ) ) { ?>
      <?php echo $order_billing_address_2; ?><br/>
    <?php } ?>

    <?php if ( !empty( $order_billing_address_3 ) ) { ?>
      <?php echo $order_billing_address_3; ?><br/>
    <?php } ?>

    <?php if ( !empty( $order_billing_town ) ) { ?>
      <?php echo $order_billing_town; ?><br/>
    <?php } ?>

    <?php if ( !empty( $order_billing_postcode ) ) { ?>
      <?php echo $order_billing_postcode; ?><br/>
    <?php } ?>

  </p>

  <?php if ( !empty( $order_telephone_number ) ) { ?>
    <p>Telephone Number: <strong><?php echo $order_telephone_number; ?></strong></p>
  <?php } ?>

  <?php if ( $order_ip ) { ?>

  <p>IP: <?php echo $order_ip; ?></p>
  <?php } ?>

  <?php 
}

add_action("manage_posts_custom_column",  "orders_custom_columns");
add_filter("manage_edit-orders_columns", "orders_edit_columns");
function orders_edit_columns($columns){
  $columns = array(
    "cb" => "<input type=\"checkbox\" />",
    "title" => "Order Number",
    "items" => "Purchased",
    "deliver" => "Deliver To",
    "total" => "Total",
    "description" => "Status",
    "custom_date" => "Date",
    );
  return $columns;
}

add_filter( 'manage_orders_sortable_columns', 'add_orders_sortable_columns' );
function add_orders_sortable_columns( $columns ) {
  $columns['items'] = 'items';
  $columns['total'] = 'total';
  return $columns;
}

function orders_custom_columns($column){
  global $post;

  $user_id = get_post_meta($post->ID, 'order_user', true);
  $order_company = get_user_meta( $user_id, 'company', true ); 
  $order_billing_address_1 = get_user_meta( $user_id, 'billing_address_1', true ); 
  $order_billing_address_2 =  get_user_meta( $user_id, 'billing_address_2', true ); 
  $order_billing_address_3 = get_user_meta( $user_id, 'billing_address_3', true ); 
  $order_billing_town =  get_user_meta( $user_id, 'billing_town', true ); 
  $order_billing_postcode =  get_user_meta( $user_id, 'billing_postcode', true ); 

  $address = null;
  if ( !empty( $order_company ) ) {
    $address .= $order_company . ', ';
  }
  if ( !empty( $order_billing_address_1 ) ) {
    $address .= $order_billing_address_1 . ', ';
  }
  if ( !empty( $order_billing_address_2 ) ) {
    $address .= $order_billing_address_2 . ', ';
  }
  if ( !empty( $order_billing_address_3 ) ) {
    $address .= $order_billing_address_3 . ', ';
  }
  if ( !empty( $order_billing_town ) ) {
    $address .= $order_billing_town . ', ';
  }
  if ( !empty( $order_billing_postcode ) ) {
    $address .= $order_billing_postcode;
  }

  //Item count
  $items = null;
  $items = get_field('items', $post->ID);
  $total_items = 0;
  $baskettotal = 0;
  $count = 0;
  if ( $items ) {
    foreach ( $items as $item ) {
      $product = $item["product"];
      $quantity = $item["quantity"];
      $item_price = get_item_price( $product );
      $total = $item_price * $quantity;
      if ( $product = get_post( $product ) ) {
        $total = $item_price * $quantity;
        $total_items = $total_items + $quantity;
      }
    }
    $total_items = $total_items . ' items';
    $subtotal = get_post_meta($post->ID, 'items_subtotal', true);
    $delivery = get_post_meta($post->ID, 'delivery_cost', true);
    $baskettotal = $subtotal + $delivery;
    $total_price = '&pound;' . number_format((float)$baskettotal, 2, '.', '');
  }
  
  switch ($column) {

    case "description":
    $custom = get_post_custom();
    if ( isset($custom["order_status"][0]) && $custom["order_status"][0] == 0 || isset($custom["order_status"][0]) && $custom["order_status"][0] == 1 || isset($custom["order_status"][0]) && $custom["order_status"][0] == 2 ) {
      echo '<span style="font-weight:bold;">Uncomplete<span>';
    }
    if ( isset($custom["order_status"][0]) && $custom["order_status"][0] == 3 ) {
      echo '<span style="color:orange;font-weight:bold;">Complete<span>';
    }
    if ( isset($custom["order_status"][0]) && $custom["order_status"][0] == 4 ) {
      echo '<span style="color:green;font-weight:bold;">Dispatched<span>';
    }
    if ( isset($custom["order_status"][0]) && $custom["order_status"][0] == 5 ) {
      echo '<span style="color:red;font-weight:bold;">Cancelled<span>';
    }
    break;

    case "deliver":
    echo $address;
    break;

    case "total":
    if ( isset($total_price) ) {
      echo $total_price;
    } else {
      echo '-';
    }
    break;  

    case "items":
    echo $total_items;
    break;

    case "custom_date":
    echo get_the_time('g:ia') . ' on ' .get_the_date('jS M Y');
    break;  

  }
}

add_filter( 'post_row_actions', 'remove_row_actions', 10, 2 );
function remove_row_actions( $actions, $post ) {
  global $current_screen;
  if( $current_screen->post_type != 'orders' ) return $actions;
  unset( $actions['edit'] );
  unset( $actions['view'] );
  unset( $actions['trash'] );
  unset( $actions['inline hide-if-no-js'] );
  //$actions['inline hide-if-no-js'] .= __( 'Quick&nbsp;Edit' );

  return $actions;
}

add_action('admin_menu', 'notification_bubble_in_admin_menu');

function notification_bubble_in_admin_menu() {
    global $menu;
    global $wpdb;

    $state_posts = $wpdb->get_results("
        SELECT meta_value FROM ".
        $wpdb->prefix."postmeta
        WHERE meta_key = 'order_status'
        AND meta_value = '3'
        ORDER BY meta_value ASC",
        ARRAY_A
    );

  $state_count = count($state_posts);
  $menu[3][0] .= $state_count ? "<span class='update-plugins count-1'><span class='update-count'>$state_count </span></span>" : '';
}

add_filter('post_updated_messages', 'codex_order_updated_messages');
function codex_order_updated_messages( $messages ) {
  global $post, $post_ID;
  $messages['orders'] = array(
    0 => '',
    1 => __('Order updated.'),
    4 => __('Order updated.'),
    7 => __('Order saved.'),
  );
  return $messages;
}