<?php /* Clean up frontend theme folder path */

add_theme_support('root-relative-urls');   
add_theme_support('rewrites');           

$get_theme_name = explode('/themes/', get_template_directory());

define('THEME_NAME',                next($get_theme_name));
define('RELATIVE_PLUGIN_PATH',      str_replace(home_url() . '/', '', plugins_url()));
define('RELATIVE_CONTENT_PATH',     str_replace(home_url() . '/', '', content_url()));
define('THEME_PATH',                RELATIVE_CONTENT_PATH . '/themes/' . THEME_NAME);

function add_filters($tags, $function) {
  foreach($tags as $tag) {
    add_filter($tag, $function);
  }
}

function city_root_relative_url($input) {
  $output = wp_make_link_relative($input);
  return $output;
}

function city_add_rewrites($content) {
  global $wp_rewrite;
  $gleadell_new_non_wp_rules = array(
    'css/(.*)'     		 => 	THEME_PATH . '/css/$1',
    'js/(.*)'      		 => 	THEME_PATH . '/js/$1',
    'img/(.*)'     		 => 	THEME_PATH . '/img/$1',
    'fonts/(.*)'       =>   THEME_PATH . '/fonts/$1',
    'video/(.*)'       =>   THEME_PATH . '/video/$1',
    'plugins/(.*)'     => 	RELATIVE_PLUGIN_PATH . '/$1'
  );
  $wp_rewrite->non_wp_rules = array_merge($wp_rewrite->non_wp_rules, $gleadell_new_non_wp_rules);
  return $content;
}

function city_clean_urls($content) {
  if (strpos($content, RELATIVE_PLUGIN_PATH) > 0) {
    return str_replace('/' . RELATIVE_PLUGIN_PATH,  '/plugins', $content);
  } else {
    return str_replace('/' . THEME_PATH, '', $content);
  }
}

if (!is_multisite() && !is_child_theme()) {

  if (current_theme_supports('rewrites')) {
    add_action('generate_rewrite_rules', 'city_add_rewrites');
  }

  if (!is_admin() && current_theme_supports('rewrites')) {
    $tags = array(
      'plugins_url',
      'bloginfo',
      'stylesheet_directory_uri',
      'template_directory_uri',
      'script_loader_src',
      'style_loader_src'
    );

    add_filters($tags, 'city_clean_urls');
  }
}

function prefix_enquiry_rewrite_rule() {
  add_rewrite_rule( 'wp-admin/receipt/([^/]+)?$', 'index.php?receipt=$matches[1]', 'top' );
  add_rewrite_rule( 'vineyards/([^/]+)/([^/]+)/?$', 'index.php?country=$matches[1]&region=$matches[2]&vineyard=$matches[3]', 'top' );
  add_rewrite_rule( 'vineyards/([^/]+)/([^/]+)/([^/]+)?$', 'index.php?country=$matches[1]&region=$matches[2]&vineyard=$matches[3]', 'top' );
  add_rewrite_rule( 'vineyards/([^/]+)/([^/]+)/([^/]+)/([^/]+)?$', 'index.php?country=$matches[1]&region=$matches[2]&vineyard=$matches[3]&wine=$matches[4]', 'top' );

  add_rewrite_rule( 'subscribe/([^/]+)/?$', 'index.php?subscribe=$matches[1]', 'top' );
  add_rewrite_rule( 'subscribe/([^/]+)/([^/]+)?$', 'index.php?subscribe=$matches[1]&option=$matches[2]', 'top' );
}
add_action( 'init', 'prefix_enquiry_rewrite_rule' );

function prefix_register_query_var( $vars ) {
  $vars[] = 'receipt';
  $vars[] = 'region';
  $vars[] = 'wine';
  $vars[] = 'vineyard';
  $vars[] = 'subscribe';
  $vars[] = 'option';
  return $vars;
}
add_filter( 'query_vars', 'prefix_register_query_var', 1 );

function prefix_url_rewrite_templates() {
  if ( get_query_var( 'receipt' ) ) {
    add_filter( 'template_include', function() {
      return get_template_directory() . '/include/template/receipt.php';
    });
  }
  if ( get_query_var( 'region' ) && empty(get_query_var( 'wine' )) ) {
    add_filter( 'template_include', function() {
      return get_template_directory() . '/single-region.php';
    });
  }
  if ( get_query_var( 'vineyard' ) && empty(get_query_var( 'wine' )) ) {
    add_filter( 'template_include', function() {
      return get_template_directory() . '/single-vineyard.php';
    });
  }
  if ( get_query_var( 'vineyard' ) && !empty(get_query_var( 'wine' )) ) {
    add_filter( 'template_include', function() {
      return get_template_directory() . '/single-wine.php';
    });
  }
  if ( get_query_var( 'subscribe' ) ) {
    add_filter( 'template_include', function() {
      return get_template_directory() . '/subscribe.php';
    });
  }
}
add_action( 'template_redirect', 'prefix_url_rewrite_templates' );


function so23698827_filter_post_type_link( $link, $post ) {
  if ( $post->post_type == 'vineyard' ) {
    if ( $region = get_field( 'region', $post->ID ) ) {
      $region = get_post( $region );
      if ( $country = get_the_terms( $region->ID, 'country' ) ) {
        $link = str_replace( '%region%', current( $country )->slug . '/' . $region->post_name, $link );
      }
    }
  }
  return $link;
}
add_filter( 'post_type_link', 'so23698827_filter_post_type_link', 10, 2 );

?>