<?php
add_action( 'publish_post', 'create_sitemap' );
add_action( 'trash_post', 'create_sitemap' );
add_action( 'publish_page', 'create_sitemap' );
add_action( 'trash_page', 'create_sitemap' );
add_action( 'publish_product', 'create_sitemap' );
add_action( 'trash_product', 'create_sitemap' );

function create_sitemap() {
  $today = date( 'Y-m-d\TH:i:s+00:00' );

  $sitemap = '<?xml version="1.0" encoding="UTF-8"?>';
  $sitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

  $sitemap .= '<url>'.
  '<loc>' . esc_url( home_url( '/' ) ) . '</loc>' .
  '<lastmod>' . $today . '</lastmod>' .
  '<changefreq>Daily</changefreq>' .
  '</url>';

  $posttypes = array('post','product','article');
  $args = array( 'post_type' => $posttypes, 'orderby' => 'ID', 'order' => 'asc', 'posts_per_page' => -1, 'post__not_in' => array(1) );
  $postsForSitemap = get_posts($args);
  foreach( $postsForSitemap as $post ) {
    setup_postdata( $post );
    $sitemap .= '<url>'.
    '<loc>' . get_permalink( $post->ID ) . '</loc>' .
    '<lastmod>' . date( 'Y-m-d\TH:i:s+00:00', strtotime( $post->post_modified ) ) . '</lastmod>' .
    '<changefreq>Daily</changefreq>' .
    '</url>';
  }


  $sitemap .= '</urlset>';

  $fp = fopen( ABSPATH . 'sitemap.xml', 'w' );

  fwrite( $fp, $sitemap );
  fclose( $fp );
}

?>