<?php
function checkSubscriber() {
	$subscriber = false;
	$current_user = wp_get_current_user();
	$date = date("Y-m-d H:i:s"); 
	if ( $current_user ) {
		// update_user_meta( $current_user->ID, 'subscription', $date);
		$expiry = get_user_meta( $current_user->ID, 'subscription', true ); 
		if ( $expiry && $expiry > $date ) {
			$subscriber = true;
		}
	}
	return $subscriber;
}


function subscriptionExpiryDiff() {
	$current_user = wp_get_current_user();
	if ( checkSubscriber() ) {
		$date = strtotime(date("Y-m-d H:i:s")); 
		$expiry = strtotime(get_user_meta( $current_user->ID, 'subscription', true )); 
		$datediff = number_format(($expiry - $date)/24/3600);
		return $datediff;
	} else {
		return null;
	}
}


function subscriptionExpiryDate() {
	$current_user = wp_get_current_user();
	if ( checkSubscriber() ) {
		$expiry = get_user_meta( $current_user->ID, 'subscription', true ); 
		return date("jS F Y", strtotime($expiry)) . ' at ' . date("H:sa", strtotime($expiry));
	} else {
		return null;
	}
}
