<?php

class Shop {

	public function __construct() {
		$this->wooFilters();
		$this->removeWooActions();
		$this->addWooActions();
	}

	public function wooFilters() {

		// disables shop default title markup
		add_filter( 'woocommerce_show_page_title', '__return_false' );

		// column count on archive pages
		add_filter('loop_shop_columns', array($this, 'columnCount'));

		add_filter('woocommerce_get_price_html', array($this, 'singleProductAddToPrice'));

		add_filter('woocommerce_product_single_add_to_cart_text', array($this, 'changeAddToCartLabel'));

		// remove description from description tab
		add_filter('woocommerce_product_description_heading', '__return_null');

		add_filter( 'woocommerce_product_tabs', array($this, 'addTasteTab') );

		add_filter( 'woocommerce_output_related_products_args', array($this, 'relatedProductCount') );
 
 		// disable password reset email notification
 		add_filter( 'send_password_change_email', '__return_false' );
	}


	public function removeWooActions() {
		remove_action( 'woocommerce_archive_description', 'action_woocommerce_archive_description', 10, 2 );

		// Remove the sorting dropdown from Woocommerce
		remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_catalog_ordering', 30 );

		// Remove the result count from WooCommerce
		remove_action( 'woocommerce_before_shop_loop' , 'woocommerce_result_count', 20 );

		//remove price, title, add to basket from shop page
		remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
		remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
		remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

		//move tabs under the summary
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );

		//remove meta
		remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );

		// remove related products
		remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );


	}

	public function addWooActions() {
		add_action( 'woocommerce_single_product_summary', 'woocommerce_output_product_data_tabs', 60 );
		add_action( 'woocommerce_before_single_product_summary', array( $this, 'singleProductBeforeWrapper'), 1 );
		add_action( 'woocommerce_after_single_product_summary', array( $this, 'singleProductAfterWrapper'), 90 );
		add_action( 'woocommerce_single_product_summary', array( $this, 'addMultiBuy' ), 35 );
		add_action( 'woocommerce_single_product_summary', array( $this, 'addBlends' ), 40 );
		add_action( 'woocommerce_after_single_product', 'woocommerce_output_related_products',10 );

	}

	public function columnCount() {
		return 2;
	}

	public function singleProductBeforeWrapper() {
		echo '<div class="pd-v-lg"><div class="grey-strip"></div><div class="container">';
	}

	public function singleProductAfterWrapper() {
		echo '</div></div>';
	}

	public function singleProductAddToPrice($price) {
		global $product;
		$price .= ' <small>(excl VAT) per bottle</small>';
		return $price;
	}

	public function changeAddToCartLabel() {
    	return __('Add to basket', 'woocommerce');
	}

	public function addBlends() {
		echo get_template_part('woocommerce/partials/blends');
	}

	public function addMultiBuy() {
		echo get_template_part('woocommerce/partials/multibuy');
	}
	public function addTasteTab($tabs) {
		$tabs['ddui'] = array(
			'title'     => __( 'Tasting Notes', 'woocommerce' ),
			'priority'  => 50,
			'callback'  => populateTasteTab
		);

		return $tabs;
	}

	public function relatedProductCount() {
		$args['posts_per_page'] = 3;
		$args['columns'] = 3; 
		return $args;
	}
}