<?php

$order = $_SESSION["basket"]['order']['order_id'];
$user_id = $_SESSION["basket"]['order']['order_user'];

$address1Err = $address2Err = $townErr = $postcodeErr = $titleErr = $firstnameErr = $lastnameErr = $telErr = $deliveryareaErr = "";

$company = sanitize_text_field( $_POST['company'] );
$line1 = sanitize_text_field( $_POST['line1'] );
$line2 = sanitize_text_field( $_POST['line2'] );
$line3 = sanitize_text_field( $_POST['line3'] );
$town = sanitize_text_field( $_POST['town'] );
$postcode = sanitize_text_field( $_POST['postcode'] );
$title = sanitize_text_field( $_POST['title'] );
$first_name = sanitize_text_field( $_POST['first_name'] );
$surname = sanitize_text_field( $_POST['last_name'] );
$tel = sanitize_text_field( $_POST['tel'] );
$nicename = $first_name . ' ' . $surname;

if ( !empty( $company ) ) {
	update_user_meta( $user_id, 'company', $company);
} 

if ( !empty( $line1 ) ) {
	update_user_meta( $user_id, 'billing_address_1', $line1);
} else {
	$address1Err = "Address line 1 required";
}

if ( !empty( $line2 ) ) {
	update_user_meta( $user_id, 'billing_address_2', $line2);
} else {
	$address2Err = "Address line 2 required";
}

if ( !empty( $line3 ) ) {
	update_user_meta( $user_id, 'billing_address_3', $line3);
}

if ( !empty( $town ) ) {
	update_user_meta( $user_id, 'billing_town', $town);
} else {
	$townErr = "Town required";
}

if ( !empty( $postcode ) ) {
	$postcode = strtoupper(str_replace(' ','',$postcode));
    if( preg_match("/^[A-Z]{1,2}[0-9]{2,3}[A-Z]{2}$/",$postcode) || preg_match("/^[A-Z]{1,2}[0-9]{1}[A-Z]{1}[0-9]{1}[A-Z]{2}$/",$postcode) || preg_match("/^GIR0[A-Z]{2}$/",$postcode)) {
		if (
			substr($postcode,0,2) == 'HE' ||
			substr($postcode,0,2) == 'KW' ||
			substr($postcode,0,2) == 'BT' ||
			substr($postcode,0,2) == 'IV' ||
			substr($postcode,0,2) == 'IM' ||
			substr($postcode,0,4) == 'TR21' ||
			substr($postcode,0,4) == 'TR22' ||
			substr($postcode,0,4) == 'TR23' ||
			substr($postcode,0,4) == 'TR24' ||
			substr($postcode,0,4) == 'TR25' ||
			substr($postcode,0,2) == 'GY' ||
			substr($postcode,0,2) == 'JE' ||
			substr($postcode,0,2) == 'ZE' ||
			substr($postcode,0,2) == 'PA' ||
			substr($postcode,0,4) == 'PO30' ||
			substr($postcode,0,4) == 'PO31' ||
			substr($postcode,0,4) == 'PO32' ||
			substr($postcode,0,4) == 'PO33' ||
			substr($postcode,0,4) == 'PO34' ||
			substr($postcode,0,4) == 'PO35' ||
			substr($postcode,0,4) == 'PO36' ||
			substr($postcode,0,4) == 'PO37' ||
			substr($postcode,0,4) == 'PO38' ||
			substr($postcode,0,4) == 'PO39' ||
			substr($postcode,0,4) == 'PO40' ||
			substr($postcode,0,4) == 'PO41'
		) {
			$deliveryareaErr = "Unfortunatly we unable to deliver to the entered address, please call a member of our team on <strong>01472 371661</strong> to discuss delivery.";
		} else {
			update_user_meta( $user_id, 'billing_postcode', $postcode);
		}
	} else {
	    	$postcodeErr = "Invalid postcode";
    }
} else {
	$postcodeErr = "Postcode required";
}

if ( !empty( $title ) ) {
	update_user_meta( $order, 'title', $title);
} else {
	$titleErr = "Title required";
}

if ( !empty( $first_name ) ) {
	update_user_meta( $user_id, 'first_name', $first_name);
} else {
	$firstnameErr = "First Name required";
}

if ( !empty( $surname ) ) {
	update_user_meta( $user_id, 'last_name', $surname);
} else {
	$lastnameErr = "Surname required";
}

if ( !empty( $tel ) ) {
	if( ctype_digit($tel) && (int)$tel > 0 ) {
		update_user_meta( $user_id, 'telephone_number', $tel);
	} else {
		$telErr = "Invalid phone number";	
	}
} else {
	$telErr = "Telephone required";
}

//Check all required fields have data
if ( empty($address1Err) && empty($address2Err) && empty($townErr) && empty($postcodeErr) && empty($titleErr) && empty($firstnameErr) && empty($lastnameErr) && empty($telErr) && empty($deliveryareaErr) ) {
	wp_redirect('checkout?step=2'); exit();
}