	<?php if ( isset( $_SESSION["basket"]['items'] ) ) {
			$items = $_SESSION["basket"]['items'];
		}
		?>
		<?php if ( isset($items) && count($items) ) { ?>

		<strong>Order Review</strong>
		<table class="table table-basket" cellspacing="0" cellpadding="0">
			<thead>
				<tr>
					<th class="table-basketthumb">Item</th>
					<th class="table-basketprice mobile-hide text-right">Item Price</th>
					<th class="table-baskettotal text-right">Item Total <span class="text-meta text-faded">(excl VAT)</span></th>
				</tr>
			</thead>
			<tbody>
				<?php
				foreach ($items as $item) {
					$product = $item["product"];
					$variation = $item["variation"];
					$quantity = $item["quantity"];
					$gift = $item["gift"];
					$item_price = get_item_price( $product, $variation );
					$item_total = $item_price * $quantity;
					if ( $product = get_post( $product ) ) {  ?>

						<tr class="item">
							<td><a href="<?php echo get_permalink( $product->ID ); ?>" target="_blank">x<?php echo $quantity; ?> <?php echo $product->post_title; ?></a>
							<p class="meta"><?php echo get_variation_details( $product, $variation, $gift ); ?></p></td>
							<td class="mobile-hide text-right">&pound;<?php echo number_format((float)$item_price, 2, '.', ''); ?></td>
		
							<td class="text-right">&pound;<span class="item-total"><?php echo number_format((float)$item_total, 2, '.', ''); ?></span></td>
						</tr>
						<?php } //if post found ?>

					<?php } ?>

			</tbody>
		</table>

	<div class="container">
		<div class="col-12 text-right space-2">
			<?php if ( !empty( $_SESSION["basket"]['voucher']['id'] ) ) {
				$ID = $_SESSION["basket"]['voucher']['id'];
				$entity = get_post_meta($ID, 'entity', true);
				$unit = get_post_meta($ID, 'unit', true);
				$apply_to = get_post_meta($ID, 'apply_to', true);
				$code = get_post_meta($ID, 'voucher_code', true);
				if ( $entity == 'percentage' ) {
					$voucher_desc = $unit . '% off ' . $apply_to;
				} else {
					$voucher_desc = '&pound;' . $unit . ' off ' . $apply_to;
				}
				?>
				<div class="space-1">Voucher: <?php echo $voucher_desc; ?></div>
			<?php } ?>
			<div class="space-1">Sub total <span class="text-meta text-faded">(inc VAT)</span>: &pound;<span id="basket-sub-cost"><?php echo basket_cost(); ?></span></div>
			<div class="space-1">Delivery: <span id="basket-delivery-cost">
				<?php if ( delivery_total_cost() <= '0' ) {
					echo 'Free';
				} else {
					echo '&pound;' . delivery_total_cost();
				} ?>
				</span></div>
			<strong>Total <span class="text-meta text-faded">(inc VAT)</span>: &pound;<span id="basket-total-cost"><?php echo basket_total_cost(); ?></span></strong>
		</div>
	</div>
	<?php } ?>