<?php
$country = get_query_var( 'country' );
$region = get_query_var( 'region' );
$vineyard = get_query_var( 'vineyard' );
$wine = get_query_var( 'wine' );
?>

<div class="bg-light breadcrumbs hide-md">

	<div class="container">

		<ul>

			<li>

				<a href="/">Home</a>

			</li>
			<?php if ( $country && !$wine ) { ?>

			<li>

				<a href="<?php echo site_url('vineyards'); ?>">Vineyards</a>

			</li>
			<?php } ?>
			<?php if ( $wine || is_singular('product') ) { ?>

			<li>

				<a href="<?php echo site_url('shop'); ?>">Shop</a>

			</li>
			<?php } ?>
			<?php if ( $country ) { $country = get_term_by('slug', $country, 'country'); ?>

			<li>

				<a href="<?php echo get_term_link( $country ); ?>"><?php echo $country->name; ?></a>

			</li>
			<?php } ?>
			<?php if ( $country && $region ) { $region = get_page_by_path($region,OBJECT,'region'); ?>

			<li>

				<a href="<?php echo get_permalink( $region->ID ); ?>"><?php echo get_the_title( $region->ID ); ?></a>

			</li>
			<?php } ?>
			<?php if ( $vineyard ) { $vineyard = get_page_by_path($vineyard,OBJECT,'vineyard'); ?>

			<li>

				<a href="<?php echo get_permalink( $vineyard->ID ); ?>"><?php echo get_the_title( $vineyard->ID ); ?></a>

			</li>
			<?php } ?>
			<?php if ( $wine ) { $wine = get_page_by_path($wine,OBJECT,'product'); ?>

			<li>

				<a href="<?php echo get_permalink( $wine->ID ); ?>"><?php echo get_the_title( $wine->ID ); ?></a>

			</li>
			<?php } ?>
			<?php if ( is_singular('event') ) { ?>

			<li>

				<a href="<?php echo site_url('events'); ?>">Events</a>

			</li>
			<?php } ?>
			<?php if ( !is_singular('vineyard') && !is_singular('region') && is_page() || !is_singular('vineyard') && !is_singular('region') && is_single() ) { ?>

			<li>

				<a href="<?php echo get_permalink( get_the_ID() ); ?>"><?php echo get_the_title( get_the_ID() ); ?></a>

			</li>
			<?php } ?>
			<?php if ( get_query_var( 'subscribe' ) ) { ?>

			<li>

				<a href="<?php echo site_url( 'subscribe' ); ?>">Subscribe</a>

			</li>
			<?php } ?>

		</ul>

	</div>

</div>