<?php
$title = get_sub_field('title');
$content = get_sub_field('content');
$background_colour = get_sub_field("background_colour");
$building = get_field('building', 'options');
$street = get_field('street', 'options');
$town = get_field('town', 'options');
$country = get_field('country', 'options');
$postcode = get_field('postcode', 'options');
?>

<div class="bg-dark text-contrast pd-v-lg">

	<div class="container text-center">

		<p class="text-bold">Our UK Distributer is Special Cases</p>

		<p><a href="tel:<?php echo str_replace(' ', '', get_field('telephone', 'options') ); ?>" title="Call Us"><?php the_field('telephone', 'options'); ?></a> &nbsp;/&nbsp; <a href="mailto:<?php echo str_replace(' ', '', get_field('email', 'options') ); ?>" title="Email"><?php the_field('email', 'options'); ?></a></p>

	</div>

</div>

<div class="bg-<?php echo $background_colour; ?><?php if ( $background_colour == 'dark' ) { echo ' text-contrast'; } ?> pd-v-lg">

	<?php if ( $title || $content ) { echo '<div class="container container-thin text-center space-2">'; } ?>

	<?php if ( $title ) { echo '<h1 class="text-heading text-huge">' . $title . '</h1>'; } ?>

	<?php if ( $content ) { echo $content; } ?>

	<?php if ( $title || $content ) { echo '</div>'; } ?>

	<?php include get_template_directory() . '/include/template/form/contact.php'; ?>

</div>
