<?php
$subtitle = get_sub_field('sub_title');
$title = get_sub_field('title');
$content = get_sub_field('content');
$textAlign = get_sub_field('text_align');
$showLink = get_sub_field("show_link");
$link = get_sub_field("link");
$linkTitle = get_sub_field("link_title");
$background_colour = get_sub_field("background_colour");
$background_image = get_sub_field("background_image");
$padding = get_sub_field('padding');
$paddingBottom = get_sub_field('padding_bottom');
$links = get_sub_field('links');
$invertText = get_sub_field('invert_text');
$halfWidth = get_sub_field('half_width');
?>

<div class="bg-cover <?php echo $textAlign; ?> <?php if ( $paddingBottom ) { echo ' pd-bottom-' . $paddingBottom; } ?> bg-<?php echo $background_colour; ?><?php if ( $invertText ) { echo ' text-contrast'; } ?> pd-v-<?php echo $padding; ?>"<?php if ( $background_image ) { ?> style="background-image: url('<?php echo $background_image["sizes"]["hero"]; ?>');"<?php } ?>>
	
	<div class="container<?php if ( $textAlign == 'text-center' ) { echo ' container-thin'; } ?>">
		<?php if ( $halfWidth ) { ?>

		<div class="col-6 col-12-sm">
		<?php } ?>
		<?php if ( $subtitle ) { ?>

		<h4 class="text-light text-spaced text-uppercase"><?php echo $subtitle; ?></h4>
		<?php } ?>
		<?php if ( $title ) { ?>

			<h1 class="text-heading text-huge space-1"><?php echo $title; ?></h1>
		<?php } ?>
		<?php if ( $content ) { ?>

			<div class="content <?php if ( $links ) { ?> space-2<?php } ?>"><?php echo $content; ?></div>
		<?php } ?>
		<?php if ( $links ) { ?>

			<?php foreach ( $links as $link ) { ?>

			<a href="<?php echo $link['link']; ?>" class="btn btn-<?php echo $link['style']; ?> btn-more" title="<?php echo $link['link']; ?>"><?php echo $link['title']; ?></a>
			<?php } ?>

		<?php } ?>
		<?php if ( $halfWidth ) { ?>

		</div>
		<?php } ?>

	</div>

</div>