jQuery(function($) {

    function landing_carousel() {
        $('#hero-slider .slider').carousel({
            directionNav: true,
            useCSS: false,
            start: function (slider) {
                $('#hero-slider').removeClass('loading');
            }
        });
    }

    function review_carousel() {
        $('.review-slides').carousel({
            directionNav: true,
            smoothHeight: true,
            controlNav: false,
            start: function (slider) {
                $('.review-slides').removeClass('loading');
            }
        });
    }

    function product_carousel() {
        $('.product-images').carousel({
            directionNav: true,
            smoothHeight: true,
            controlNav: false,
            start: function (slider) {
                $('.product-images').removeClass('loading');
            }
        });
    }

    function flexsliderHeightBugWorkaround() {
        $('.slider').each(function () {
            if ($(this).height() < 80) {
                $(window).resize();
                return false;
            }
        });
    }

    $('.content-slides').each(function (e, v) {
        $(v).carousel({
            smoothHeight: true,
            directionNav: true,
            controlNav: false,
            start: function (slider) {
                slider.removeClass('loading');
            }
        });
    });

    function vineyard_carousel() {
        $('.vineyard-slides').each(function (e, v) {
            $(v).carousel({
                smoothHeight: true,
                directionNav: true,
                controlNav: true,
                slideshow: false,
                start: function (slider) {
                    slider.removeClass('loading');
                }
            });
        });
    }

    function add_to_basket(i) {
        var price = 0;
        if ($(i).find('option:selected').length) {
            var value = $(i).find('option:selected').last().val();
            if (value) {
                var price = price + parseFloat(value);
            }
        }
        if ($(i).find('input:checked').length) {
            var value = $(i).find('input:checked').last().attr("data-price");
            if (value) {
                var price = price + parseFloat(value);
            }
        }
        $(i).find("span.variation-price").html(price.toFixed(2));
    }

    function sticky_header() {
        var elSelector = '#header',
            $element = $(elSelector);

        if (!$element.length) return true;

        var elHeight = 0,
            elTop = 0,
            $document = $(document),
            dHeight = 0,
            $window = $(window),
            wHeight = 0,
            wScrollCurrent = 0,
            wScrollBefore = 0,
            wScrollDiff = 0;

        $window.on('scroll', function () {
            elHeight = $element.outerHeight() + 50;
            dHeight = $document.height();
            wHeight = $window.height();
            wWidth = $window.width();
            wScrollCurrent = $window.scrollTop();
            wScrollDiff = wScrollBefore - wScrollCurrent;
            elTop = parseInt($element.css('top')) + wScrollDiff;

            if ($("header#header").length && wScrollCurrent >= elHeight) {
                $element.addClass("header-trans")
            } else {
                $element.removeClass("header-trans")
            }
            if (wScrollCurrent <= 0) {
                $element.removeClass("header-affixed");
                if (!$('#main').hasClass('nobg')) {
                    $('.header-rel').height(0);
                }
            } else {
                $element.addClass("header-affixed");
                if (!$('#main').hasClass('nobg')) {
                    $('.header-rel').height(elHeight);
                }
            }
            if (wScrollCurrent <= 0) {
                $element.css('top', 0);
            } else if (wScrollDiff > 0) {
                $element.css('top', elTop > 0 ? 0 : elTop);
            } else if (wScrollDiff < 0) {
                $element.css('top', Math.abs(elTop) > elHeight ? -elHeight : elTop);
            }
            wScrollBefore = wScrollCurrent;
        });
    }

    $(document).on('opened', '.modal-search', function () {
        $('input[name="s"]').first().focus();
    });

    $.fn.isInViewport = function () {
        var elementTop = $(this).offset().top;
        var elementBottom = elementTop + $(this).outerHeight();

        var viewportTop = $(window).scrollTop();
        var viewportBottom = viewportTop + $(window).height();

        return elementBottom > viewportTop && elementTop < viewportBottom;
    };


    $(window).on('resize scroll load', function () {
        var scrolled = $(window).scrollTop()
        $('.col-image-float').each(function (e, v) {
            var initY = $(v).offset().top
            var height = $(v).height()
            var endY = initY + $(v).height()
            var visible = $(v).isInViewport()
            if (visible && $(window).width() > 720) {
                var diff = scrolled - initY
                var ratio = Math.round((diff / height) * 100)
                $(v).css('transform', 'translateY(' + parseInt(-(ratio / 8)) + 'px)');
            }
        })
    });

    $(document).ready(function () {

        $('.toggle').click(function (e) {
            e.preventDefault();
            var $this = $(this);
            if ($this.next().hasClass('show')) {
                $this.next().removeClass('show');
                $this.removeClass('active');
            } else {
                $this.parent().parent().find('li .inner').removeClass('show');
                $this.parent().parent().find('li a').removeClass('active');
                $this.next().toggleClass('show');
                $this.toggleClass('active');
            }
        });

        $(".content").fitVids();

        $('.base-top').on('click', function (event) {
            event.preventDefault();
            $("html, body").animate({scrollTop: 0}, "slow");
        });

        $('a.img-lightbox').lightbox();

        $('.tabs-nav a').on('click', function (event) {
            event.preventDefault();
            $('.tab-active').removeClass('tab-active');
            $(this).parent().addClass('tab-active');
            $('.tabs-stage div').hide();
            $($(this).attr('href')).show();
        });
        $('.tabs-nav a:first').trigger('click');

        product_carousel();
        landing_carousel();
        review_carousel();
        vineyard_carousel();
        sticky_header();

        setTimeout(flexsliderHeightBugWorkaround, 500);
        setTimeout(flexsliderHeightBugWorkaround, 2000);
        setTimeout(flexsliderHeightBugWorkaround, 5000);

        $('body').on('click', '.qty-wrap .qtyplus', function (a) {
            a.preventDefault(), fieldName = $(this).attr("field");
            var b = parseInt($(this).parent().children("input[name=" + fieldName + "]").val());
            isNaN(b) ? $(this).parent().children("input[name=" + fieldName + "]").val(1) : $(this).parent().children("input[name=" + fieldName + "]").val(b + 1)
        });

        $('body').on('click', '.qty-wrap .qtyminus', function (a) {
            a.preventDefault(), fieldName = $(this).attr("field");
            var b = parseInt($(this).parent().children("input[name=" + fieldName + "]").val());
            !isNaN(b) && b > 1 ? $(this).parent().children("input[name=" + fieldName + "]").val(b - 1) : $(this).parent().children("input[name=" + fieldName + "]").val(1)
        });

        $(".add-to-basket-form").each(function (i) {
            add_to_basket(this);
        });

        $('.subhead_dropdown').click(function (e) {
            e.preventDefault();
            $('.subhead_dropdown').removeClass('active');
            $(this).addClass('active');
            $("form.reveal").hide();
            $(this).next("form.reveal").toggle();
        });

        $('body').on('change keyup', 'form.form-product input, form.form-product select', function () {
            $('#product-detail').addClass('loading');
            var page = $('form.form-product').attr('action');
            $("form.form-product option:selected").each(function () {
                page = page + $(this).attr('data-slug') + "/";
            });
            $("form.form-product input[type=radio]:checked").each(function () {
                page = page + $(this).attr('data-slug') + "/";
            });
            add_to_basket($(this).closest('form'));
        });

        $('body').on('click', '.btn-disabled', function (e) {
            e.preventDefault();
        });

    });

    if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
        $('body').addClass('touch');
    } else {
        $(document).on('opened', '.modal-search', function () {
            $(".modal-search .form-search input:text:visible:first").focus();
        });
    }

    $("#nav > ul > li > a").on("click", function (e) {
        if ($("html").is(".nav-open")) {
            if ($(this).parent().find('.sub-menu').length) {
                e.preventDefault();
                $(this).closest('li').find('.sub-menu').addClass('open');
            }
        }
    });

    $(".menu").on("click", function (e) {
        e.preventDefault();
        $(".menu").toggleClass("active");
        $("html").toggleClass("nav-open");
    });

    $(".login").on("click", function (e) {
        e.preventDefault();
        $("html").toggleClass("login-open");
    });

    $(".close-submenu").on("click", function (e) {
        e.preventDefault();
        $(".sub-menu").removeClass("open");
    });

    $(document).mouseup(function (e) {
        var container = $("nav#nav a, .menu");
        if (!container.is(e.target) && container.has(e.target).length === 0 && $("html.nav-open").length != 0) {
            $(".menu").removeClass("active");
            $("html").removeClass("nav-open");
        }
    });

    $('body').on('click', '.variant-radio-button', function () {
        var value = $(this).val();
        $(this).closest('.form-row').find('input.variation').last().val(value);
    });

    $('body').on('click', 'form.form-add-to-basket .submit', function (a) {
        a.preventDefault();
        $btn = $(this);
        $form = $btn.closest('form');
        $btn.addClass('btn-loading');
        var product = $form.find('input[name="product"]').val();
        var variations = $form.find('input[name="variation[]"]').map(function () {
            return $(this).val();
        }).get();
        if ($form.find('select[name="quantity"]').length) {
            var quantity = $form.find('select[name="quantity"]').val();
        } else {
            var quantity = $form.find('input[name="quantity"]').val();
        }
        var gift = $form.find('input[name="gift"]').val();
        $.ajax({
            type: "POST",
            url: "/wp-admin/admin-ajax.php",
            data: {
                action: "add_to_basket",
                product: product,
                variation: variations,
                quantity: quantity,
                gift: gift
            },
            dataType: "json",
            context: this,
            success: function (a) {
                $(this).closest('form.form-add-to-basket').find(".submit").removeClass('btn-loading');
                if ($btn.hasClass('btn-go-checkout')) {
                    $(location).attr('href', '/checkout/?step=1&amp;ref=basket');
                } else {
                    $(".add-to-basket-msg").html(a.msg)
                }
            }
        })
    });


    $('body').on('click', 'form.form-checkout .btn', function (a) {
        a.preventDefault();
        var $this = $(this);
        var $form = $this.closest('form');
        $this.addClass('btn-loading');
        $.ajax({
            type: 'POST',
            url: "/wp-admin/admin-ajax.php",
            data: $form.serialize(),
            success: function (response) {
                if (response.status == 'success') {
                    $form.submit();
                } else {
                    $this.removeClass('btn-loading');
                    $form.next('.form-process-msg').removeClass('hide').html(response.msg);
                }
            }
        });
    });

    $('body').on('click', 'form.form-newsletter .btn', function (a) {
        var $this = $(this);
        var $form = $this.closest('form');
        $this.addClass('btn-loading');
        $.ajax({
            type: 'POST',
            url: "/wp-admin/admin-ajax.php",
            data: {
                action: "newsletter",
                nonce: $form.find('input[name="nonce"]').val(),
                email: $form.find('input[name="email"]').val()
            },
            success: function (response) {
                if (response.status == 'success') {
                    $form.hide();
                    $form.next('.form-msg').removeClass('hide').addClass('alert-success').html(response.msg);
                } else {
                    $this.find('button').removeClass('btn-loading');
                    $form.next('.form-msg').removeClass('hide').html(response.msg);
                }
            }
        });
        return false;
    });

    $('body').on('click', 'form#form-contact .btn', function (a) {
        a.preventDefault();
        var $this = $(this);
        var $form = $this.closest('form');
        $this.addClass('btn-loading');
        var data = {
            action: "contact",
            nonce: $('input[name="nonce"]').val(),
            name: $('input[name="name"]').val(),
            email: $('input[name="email"]').val(),
            telephone: $('input[name="telephone"]').val(),
            message: $('textarea[name="enquiry"]').val()
        };
        $.ajax({
            type: 'POST',
            url: "/wp-admin/admin-ajax.php",
            data: data,
            success: function (response) {
                if (response.status == 'success') {
                    $form.hide();
                    $form.next('.form-contact-msg').removeClass('hide').addClass('alert-success').html(response.msg);
                } else {
                    $this.removeClass('btn-loading');
                    $form.next('.form-contact-msg').removeClass('hide').html(response.msg);
                }
            }
        });
    });

    $("form#basket_update_form input.update").click(function (a) {
        a.preventDefault();
        $form = $(this).closest('form');
        $(".update_message").html('');
        var product = $form.find('input[name="product"]').val(),
            variations = $form.find('input[name="variation[]"]').map(function () {
                return $(this).val();
            }).get(),
            quantity = $form.find('input[name="quantity"]').val(),
            gift = $form.find('input[name="gift"]').val();
        $(this).parent().find(".update_message").html('<img src="/img/loading.gif" alt="Loading...">'), $.ajax({
            type: "POST",
            url: "/wp-admin/admin-ajax.php",
            data: {
                action: "update_basket",
                product: product,
                variation: variations,
                quantity: quantity,
                gift: gift
            },
            dataType: "json",
            context: this,
            success: function (a) {
                $(this).closest("tr").find(".update_message").html(a.msg);
                $(this).closest("tr").find("span.item-total").html(a.price);
                $("span#basket-sub-cost").html(a.sub);
                $("span#basket-total-cost").html(a.total);
                $("span#basket-delivery-cost").html(a.delivery);
                $("#alert-bottles").addClass('hide');
                $("#btn-checkout").removeClass('btn-disabled');
                if (a.bottleAlert == false) {
                    $("#alert-bottles").removeClass('hide');
                    $("#btn-checkout").addClass('btn-disabled');
                }
            }
        })
    });

    $("form#basket_update_form input.remove").click(function (a) {
        a.preventDefault();
        $form = $(this).closest('form');
        $(".update_message").html('');
        var product = $form.find('input[name="product"]').val(),
            variations = $form.find('input[name="variation[]"]').map(function () {
                return $(this).val();
            }).get(),
            quantity = $form.find('input[name="quantity"]').val(),
            gift = $form.find('input[name="gift"]').val();
        $(this).parent().find(".update_message").html('<img src="/img/loading.gif" alt="Loading...">'), $.ajax({
            type: "POST",
            url: "/wp-admin/admin-ajax.php",
            data: {
                action: "remove_basket",
                product: product,
                variation: variations,
                quantity: quantity,
                gift: gift
            },
            dataType: "json",
            context: this,
            success: function (a) {
                $(this).closest("tr").hide();
                $("span#basket-sub-cost").html(a.sub);
                $("span#basket-total-cost").html(a.total);
                $("span#basket-delivery-cost").html(a.delivery);
                $("#alert-bottles").addClass('hide');
                $("#btn-checkout").removeClass('btn-disabled');
                if (a.bottleAlert == false) {
                    $("#alert-bottles").removeClass('hide');
                    $("#btn-checkout").addClass('btn-disabled');
                }
            }
        })
    });

   jQuery( function( $ ) {
        if ( ! String.prototype.getDecimals ) {
            String.prototype.getDecimals = function() {
                var num = this,
                    match = ('' + num).match(/(?:\.(\d+))?(?:[eE]([+-]?\d+))?$/);
                if ( ! match ) {
                    return 0;
                }
                return Math.max( 0, ( match[1] ? match[1].length : 0 ) - ( match[2] ? +match[2] : 0 ) );
            }
        }
        // Quantity "plus" and "minus" buttons
        $( document.body ).on( 'click', '.plus, .minus', function(e) {
            e.preventDefault();
            var $qty        = $( this ).closest( '.quantity' ).find( '.qty'),
                currentVal  = parseFloat( $qty.val() ),
                max         = parseFloat( $qty.attr( 'max' ) ),
                min         = parseFloat( $qty.attr( 'min' ) ),
                step        = $qty.attr( 'step' );

            // Format values
            if ( ! currentVal || currentVal === '' || currentVal === 'NaN' ) currentVal = 0;
            if ( max === '' || max === 'NaN' ) max = '';
            if ( min === '' || min === 'NaN' ) min = 0;
            if ( step === 'any' || step === '' || step === undefined || parseFloat( step ) === 'NaN' ) step = 1;

            // Change the value
            if ( $( this ).is( '.plus' ) ) {
                if ( max && ( currentVal >= max ) ) {
                    $qty.val( max );
                } else {
                    $qty.val( ( currentVal + parseFloat( step )).toFixed( step.getDecimals() ) );
                }
            } else {
                if ( min && ( currentVal <= min ) ) {
                    $qty.val( min );
                } else if ( currentVal > 0 ) {
                    $qty.val( ( currentVal - parseFloat( step )).toFixed( step.getDecimals() ) );
                }
            }

            // Trigger change event
            $qty.trigger( 'change' );
        });
    });
});