<?php get_header(); ?>

<?php while ( have_posts() ) { the_post(); ?>

<?php
$images = get_field('images');
$blend = get_field('blend');
$age_of_vines = get_field('age_of_vines');
$abv = get_field('abv');
$vintage = get_field('vintage');
$description = get_field('description');
$harvest = get_field('harvest');
$vinification = get_field('vinification');
$ageing = get_field('ageing');
$colour = get_field('colour');
$nose = get_field('nose');
$on_the_palate = get_field('on_the_palate');
$serving_suggestions = get_field('serving_suggestions');
$price = get_field('price');
$stock = get_field('stock');
$vat_rate = get_field('vat_rate','option');
?>

<div class="pd-v-lg">

	<div class="grey-strip"></div>

	<div class="container">
		<?php if ( isset($images) && !empty($images) ) { ?>

		<div class="col-6 col-12-sm space-2-sm pd-h-md">

			<div class="container product-images-full">

				<div class="slider">

					<ul class="slides">
						<?php foreach ($images as $image) { ?>

						<li>

							<div class="<?php if ( has_term('wine', 'type') || has_term('olive-oil', 'type') ) { echo 'wine-image '; } ?>text-center">

								<?php if ( $vintage ) { echo '<span class="wine-vintage">' . $vintage . '</span>'; } ?>

								<a href="<?php echo $image['sizes']['fullsize']; ?>" title="<?php the_title(); ?>" class="img-lightbox">

									<img src="<?php echo $image['sizes']['medium-3x4']; ?>" alt="<?php the_title(); ?>" class="<?php if ( has_term('wine', 'type') || has_term('olive-oil', 'type') ) { echo 'img-wine'; } else { echo 'img-responsive'; } ?>">

								</a>

							</div>

						</li>
						<?php } ?>

					</ul>

				</div>

			</div>

		</div>
		<?php } else { ?>

		<div class="col-6 col-12-sm space-2-sm pd-h-md">

			<img src="<?php echo site_url('img/default.jpg'); ?>" class="img-responsive">

		</div>
		<?php } ?>

		<div class="col-6 col-12-sm">

			<div class="container pd-v-md"></div>

			<div class="pd-v-md">

				<?php if ( $vintage ) { echo '<h4>Dyson ' . $vintage . '</h4>'; } ?>

				<h1 class="text-heading text-huge"><?php the_title(); ?></h1>

			</div>

			<div class="container space-2">

				<div class="col-4 pd-v-sm">

					<p class="nowrap"><span class="h3 text-bold">&pound;<?php echo number_format($price, 2); ?></span><?php if ( has_term('wine', 'type') || has_term('olive-oil', 'type') ) { echo ' <span class="text-meta">(excl VAT) per bottle</span></p>'; } ?>

				</div>

				<div class="col-8">
					<?php if ( empty($stock) ) { ?>

						<span class="btn btn-block btn-disabled btn-grey">Out of stock</span>
					<?php } else { ?>

					<form action="<?php the_permalink(); ?>" method="post" class="form-add-to-basket container">

						<div class="col-6">

							<input type="hidden" name="gift" value="0" />

							<input type="hidden" name="product" value="<?php echo $id; ?>" />

							<div class="select">

								<select name="quantity">
									<?php for ($q = 1; $q <= 12; $q++) { echo '<option value="' . $q . '">' . $q . '</option>'; } ?>

								</select>

							</div>

						</div>

						<div class="col-6">

							<button type="submit" class="btn btn-block btn-primary<?php if ( !$stock ) { echo ' btn-disabled'; } ?> submit">Add &nbsp;<i class="icon-basket"></i></button>

						</div>

					</form>
					<?php } ?>

				</div>

			</div>
			<?php if ( has_term('wine', 'type') ) { ?>
			<?php if ( !empty($stock) ) { ?>
			<div class="container text-center space-2">

				<div class="col-6">

					<form action="<?php the_permalink(); ?>" method="post" class="form-add-to-basket">

						<input type="hidden" name="quantity" value="12" />

						<input type="hidden" name="gift" value="0" />

						<input type="hidden" name="product" value="<?php echo get_the_ID(); ?>" />

						<button type="submit" class="btn btn-light btn-block submit">Add 12 Bottles <br>&pound;<?php echo number_format((($price) * (1 + ($vat_rate/100))) * 12, 2); ?></button>

					</form>

				</div>

				<div class="col-6">

					<form action="<?php the_permalink(); ?>" method="post" class="form-add-to-basket">

						<input type="hidden" name="quantity" value="24" />

						<input type="hidden" name="gift" value="0" />

						<input type="hidden" name="product" value="<?php echo get_the_ID(); ?>" />

						<button type="submit" class="btn btn-light btn-block submit">Add 24 Bottles <br>&pound;<?php echo number_format((($price) * (1 + ($vat_rate/100))) * 24, 2); ?></button>

					</form>

				</div>

			</div>

			<div class="add-to-basket-msg"></div>
			<?php } else { ?>

				<div class="container space-2">

					<p><div class="alert alert-warning"><a href="<?php echo site_url('contact'); ?>">Contact us for more information</a></div></p>

				</div>

			<?php } ?>

			<div class="container space-2">

				<div class="col-6">

					<div class="container">

						<div class="col-3 hide-sm">

							<div class="pd-h-sm pd-v-xs">

								<img src="<?php echo site_url('img/icon/grapes.svg'); ?>" alt="Grapes" class="img-responsive">

							</div>

						</div>

						<div class="col-9 col-12-sm">

							<p>Blend</p>

							<p><strong><?php echo $blend; ?></strong></p>

						</div>

					</div>

				</div>

				<div class="col-6">

					<div class="container">

						<div class="col-3 hide-sm">
							
							<div class="pd-h-sm pd-v-xs">

								<img src="<?php echo site_url('img/icon/vines.svg'); ?>" alt="Vines" class="img-responsive">

							</div>

						</div>

						<div class="col-9 col-12-sm">

							<p>Average age of vines</p>

							<p><strong><?php echo $age_of_vines; ?></strong></p>

						</div>

					</div>

				</div>

			</div>

			<ul class="tabs-nav">
			
				<li class="tab-active">

					<a href="#description" title="Description" rel="nofollow">Description</a>
			
				</li>
			
				<li>

					<a href="#tasting-notes" title="Tasting Notes" rel="nofollow">Tasting Notes</a>
				
				</li>
			
			</ul>
			
			<div class="tabs-stage">

				<div id="description" class="content">
				<?php if ( $abv ) { echo '<p><span class="text-bold">ABV:</span> ' . $abv . '</span></p>'; } ?>
				<?php if ( $description ) { ?>

					<span class="text-bold">Description:</span><br>

					<?php echo $description; ?>
				<?php } ?>
				<?php if ( $harvest ) { ?>

					<span class="text-bold">Harvest:</span><br>

					<?php echo $harvest; ?>
				<?php } ?>
				<?php if ( $vinification ) { ?>

					<span class="text-bold">Vinification:</span><br>

					<?php echo $vinification; ?>
				<?php } ?>
				<?php if ( $ageing ) { ?>

					<span class="text-bold">Ageing:</span><br>

					<?php echo $ageing; ?>
				<?php } ?>

				</div>

				<div id="tasting-notes" class="content">
				<?php if ( $colour ) { ?>

					<span class="text-bold">Colour:</span><br>

					<?php echo $colour; ?>
				<?php } ?>
				<?php if ( $nose ) { ?>

					<span class="text-bold">Nose:</span><br>

					<?php echo $nose; ?>
				<?php } ?>
				<?php if ( $on_the_palate ) { ?>

					<span class="text-bold">On The Palate:</span><br>

					<?php echo $on_the_palate; ?>
				<?php } ?>
				<?php if ( $serving_suggestions ) { ?>

					<br>

					<span class="text-bold">Serving Suggestions:</span><br>
					<?php foreach ($serving_suggestions as $serving) { ?>
				
					<p>

						<span class="text-quote">&#34;<?php echo $serving['suggestion']; ?>&#65282;</span><br>

						<span class="text-bold"><?php echo $serving['author']; ?></span><br>

						<span class="text-faded text-meta"><?php echo $serving['location']; ?></span>

					</p>
					<?php } ?>
				<?php } ?>
				
				</div>

			</div>
			<?php } else { ?>
			<?php if ( $description ) { ?>

			<ul class="tabs-nav">
			
				<li class="tab-active">

					<a href="#description" title="Description" rel="nofollow">Description</a>
			
				</li>
			
			</ul>
			
			<div class="tabs-stage">

				<div id="description" class="content">

					<?php echo $description; ?>

				</div>

			</div>
			<?php } ?>
			<?php } ?>

		</div>

	</div>

</div>
<?php if ( has_term('wine', 'type') ) { ?>
<?php $args = array(
	'post_type' 		=>		'product',
	'posts_per_page' 	=> 		3,
    'orderby' 			=>		'date',
    'post__not_in'		=>		array(get_the_ID()),
	'tax_query' => array(
	    array(
	        'taxonomy' => 'type',
	        'terms' => 'wine',
	        'field' => 'slug'
	    )
	)
);
$wines = get_posts( $args ); ?>
<?php if ( $wines ) { ?>

<div class="bg-split bg-white pd-v-lg">
	
	<div class="container text-center space-2">
		
		<a href="<?php echo site_url('wine'); ?>" title="Wine" class="btn btn-more">Other Wines</a>

	</div>

	<ul class="container grid-col-3 pd-bottom-lg">
	<?php foreach ( $wines as $wine ) { ?>

		<li>
		<?php include get_template_directory() . '/include/template/loop/product.php'; ?>

		</li>
	<?php } ?>

	</ul>

</div>
<?php } ?>
<?php } ?>
<?php } ?>
<?php get_footer(); ?>